<?php



session_start();
require_once __DIR__ . '/../config.php';
if(!isset($_SESSION['admin_id'])) header('Location: login.php');

session_start();
require_once __DIR__ . '/../config.php';
if(!isset($_SESSION['admin_id'])) header('Location: login.php');

$pdo = get_pdo();
$totals = [];
$totals['lists'] = $pdo->query('SELECT COUNT(*) FROM lists')->fetchColumn();
$totals['templates'] = $pdo->query('SELECT COUNT(*) FROM templates')->fetchColumn();
$totals['campaigns'] = $pdo->query('SELECT COUNT(*) FROM campaigns')->fetchColumn();
$totals['contacts'] = $pdo->query('SELECT COUNT(*) FROM contacts')->fetchColumn();
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Admin Dashboard</title>
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<style>
:root {
    --bg-color: #f4f6f8;
    --text-color: #111827;
    --card-bg: #fff;
    --sidebar-bg: #1f2937;
    --sidebar-link: #d1d5db;
    --sidebar-active: #374151;
}
body.dark {
    --bg-color: #0f172a;
    --text-color: #e2e8f0;
    --card-bg: #1e293b;
    --sidebar-bg: #0f172a;
    --sidebar-link: #94a3b8;
    --sidebar-active: #1e293b;
}
body {
    margin: 0;
    font-family: "Poppins", sans-serif;
    display: flex;
    height: 100vh;
    background: var(--bg-color);
    color: var(--text-color);
    transition: background 0.3s, color 0.3s;
}
.sidebar {
    width: 230px;
    background: var(--sidebar-bg);
    color: white;
    display: flex;
    flex-direction: column;
    padding: 25px 0;
    transition: background 0.3s;
}
.sidebar h2 {
    text-align: center;
    margin-bottom: 30px;
    color: #60a5fa;
}
.sidebar a {
    color: var(--sidebar-link);
    text-decoration: none;
    padding: 12px 25px;
    display: block;
    transition: 0.3s;
    font-weight: 500;
}
.sidebar a:hover,
.sidebar a.active {
    background: var(--sidebar-active);
    color: #fff;
}
.main-content {
    flex: 1;
    display: flex;
    flex-direction: column;
}
.header {
    background: var(--card-bg);
    padding: 15px 25px;
    border-bottom: 1px solid #e5e7eb;
    display: flex;
    justify-content: space-between;
    align-items: center;
}
.header h1 {
    font-size: 20px;
}
.toggle-btn {
    background: #2563eb;
    color: #fff;
    border: none;
    border-radius: 20px;
    padding: 8px 16px;
    cursor: pointer;
    font-weight: 500;
    transition: 0.3s;
}
.toggle-btn:hover {
    background: #1e40af;
}
.logout-btn {
    background: #dc2626;
    color: #fff;
    padding: 8px 14px;
    border-radius: 6px;
    text-decoration: none;
    margin-left: 10px;
}
.logout-btn:hover {
    background: #b91c1c;
}
.dashboard-content {
    padding: 30px;
    overflow-y: auto;
}
.card-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(220px, 1fr));
    gap: 20px;
}
.card {
    background: var(--card-bg);
    border-radius: 10px;
    padding: 20px;
    text-align: center;
    box-shadow: 0 4px 12px rgba(0,0,0,0.05);
    transition: background 0.3s, color 0.3s;
}
.card h3 {
    margin: 10px 0;
}
.card span {
    font-size: 26px;
    font-weight: bold;
    color: #2563eb;
}
.chart-container {
    margin-top: 40px;
    background: var(--card-bg);
    padding: 25px;
    border-radius: 10px;
    box-shadow: 0 4px 12px rgba(0,0,0,0.05);
    transition: background 0.3s;
}
.chart-container h3 {
    margin-bottom: 15px;
}
.chart-grid {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 30px;
}
@media(max-width: 768px) {
    .chart-grid {
        grid-template-columns: 1fr;
    }
}
</style>
</head>
<body>
    <div class="sidebar">
        <h2>📊 Admin Panel</h2>
        <a href="dashboard.php" class="active">🏠 Dashboard</a>
        <a href="lists.php">📋 Lists</a>
        <a href="templates.php">📄 Templates</a>
        <a href="campaigns.php">📧 Campaigns</a>
        <a href="reports.php">📊 Reports</a>
        <a href="contacts.php">👥 Contacts</a>
        <a href="logout.php">🚪 Logout</a>
    </div>

    <div class="main-content">
        <div class="header">
            <h1>Welcome Back, Admin 👋</h1>
            <div>
                <button class="toggle-btn" id="modeToggle">🌙 Dark Mode</button>
                <a class="logout-btn" href="logout.php">Logout</a>
            </div>
        </div>

        <div class="dashboard-content">
            <div class="card-grid">
                <div class="card"><h3>Total Lists</h3><span><?= $totals['lists']; ?></span></div>
                <div class="card"><h3>Total Templates</h3><span><?= $totals['templates']; ?></span></div>
                <div class="card"><h3>Total Campaigns</h3><span><?= $totals['campaigns']; ?></span></div>
                <div class="card"><h3>Total Contacts</h3><span><?= $totals['contacts']; ?></span></div>
            </div>

            <div class="chart-grid">
                <div class="chart-container">
                    <h3>📈 Emails Sent (Last 6 Months)</h3>
                    <canvas id="campaignChart" height="120"></canvas>
                </div>
                <div class="chart-container">
                    <h3>📊 Campaign Status Overview</h3>
                    <canvas id="statusChart" height="120"></canvas>
                </div>
            </div>

            <div class="chart-container">
                <h3>📧 Email Performance (Open / Bounce Rate)</h3>
                <canvas id="performanceChart" height="100"></canvas>
            </div>
        </div>
    </div>

<script>
const ctx1 = document.getElementById('campaignChart');
const ctx2 = document.getElementById('statusChart');
const ctx3 = document.getElementById('performanceChart');

new Chart(ctx1, {
    type: 'line',
    data: {
        labels: ['June', 'July', 'Aug', 'Sept', 'Oct', 'Nov'],
        datasets: [{
            label: 'Emails Sent',
            data: [200, 450, 380, 600, 720, 510],
            borderColor: '#3b82f6',
            backgroundColor: 'rgba(59,130,246,0.1)',
            borderWidth: 2,
            fill: true,
            tension: 0.4
        }]
    },
    options: { plugins: { legend: { display: false } } }
});

new Chart(ctx2, {
    type: 'pie',
    data: {
        labels: ['Sent', 'Opened', 'Bounced', 'Unsubscribed'],
        datasets: [{
            data: [60, 25, 10, 5],
            backgroundColor: ['#3b82f6','#10b981','#f59e0b','#ef4444']
        }]
    }
});

new Chart(ctx3, {
    type: 'bar',
    data: {
        labels: ['Campaign 1','Campaign 2','Campaign 3','Campaign 4'],
        datasets: [
            { label: 'Open Rate', data: [68,72,58,80], backgroundColor:'#10b981' },
            { label: 'Bounce Rate', data: [6,8,5,7], backgroundColor:'#ef4444' }
        ]
    },
    options: { scales: { y: { beginAtZero:true } } }
});

// Dark mode toggle
const btn = document.getElementById('modeToggle');
btn.onclick = () => {
    document.body.classList.toggle('dark');
    btn.textContent = document.body.classList.contains('dark') ? '☀️ Light Mode' : '🌙 Dark Mode';
};
</script>
</body>
</html>
