# SES Bulk Mailer (PHP)
Ready-to-use PHP project for sending bulk emails using Amazon SES SMTP.

Features:
- Admin panel (login) with CSS-based UI
- Create HTML templates + image upload
- Create lists and upload CSV of emails (email,name)
- Create campaigns and send bulk email via Amazon SES SMTP (PHPMailer)
- Open tracking (1x1 pixel)
- Unsubscribe link in emails
- Basic reports: opens, bounces, unsubscribes
- Endpoint to receive AWS SNS bounce/complaint notifications
- SQL schema included

Steps to run:
1. Place this project on your PHP 8.1+ enabled server (Apache/Nginx + PHP-FPM).
2. Create a MySQL database and import `db/schema.sql`.
3. Copy `config-sample.php` to `config.php` and fill DB + SMTP (Amazon SES) credentials:
   - SMTP_HOST: e.g. email-smtp.us-east-1.amazonaws.com
   - SMTP_USERNAME: your SES SMTP username
   - SMTP_PASSWORD: your SES SMTP password
   - FROM_EMAIL / FROM_NAME
4. Install dependencies using Composer:
   ```
   cd {project_name}
   composer install
   ```
   (This will install PHPMailer.)
5. Ensure `uploads/` is writable by webserver.
6. Configure AWS SES:
   - Verify sender email/domain in SES.
   - If you want bounce/complaint tracking automatically, configure SNS topic and set its HTTPS endpoint to `https://yourdomain.com/aws_sns.php`.
7. Open `/admin/login.php` and login with default admin: `admin@example.com` / `password` (change after first login).

Notes:
- This is a minimal, ready-to-run starter. For production, enable HTTPS, secure the admin (strong password, IP restrictions), and validate uploads.
