<?php
session_start();
require __DIR__ . '/../config.php';
require __DIR__ . '/../vendor/autoload.php';
use PHPMailer\PHPMailer\PHPMailer;
$conf = get_config();
if (!isset($_SESSION['admin_id'])) header('Location: login.php');
$pdo = get_pdo();
$msg = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['create_list'])) {
        $stmt = $pdo->prepare("INSERT INTO lists (name) VALUES (?)");
        $stmt->execute([$_POST['name']]);
        $msg = 'List created';
    }
    if (isset($_POST['upload_csv']) && isset($_FILES['csv'])) {
        $list_id = intval($_POST['list_id']);
        $double_optin = isset($_POST['double_optin']) ? 1 : 0;
        $csv = fopen($_FILES['csv']['tmp_name'], 'r');
        $count = 0;
        while (($row = fgetcsv($csv)) !== false) {
            $email = trim($row[0]);
            $name = $row[1] ?? '';
            if (filter_var($email, FILTER_VALIDATE_EMAIL)) {
                // insert contact; if double opt-in set unsubscribed=1 until confirmed
                $stmt = $pdo->prepare("INSERT INTO list_contacts (list_id,email,name,unsubscribed) VALUES (?,?,?,?)");
                $stmt->execute([$list_id, $email, $name, $double_optin ? 1 : 0]);
                $contact_id = $pdo->lastInsertId();
                $count++;
                if ($double_optin) {
                    // send confirmation email
                    try {
                        $mail = new PHPMailer(true);
                        $mail->isSMTP();
                        $mail->Host = $conf['smtp']['host'];
                        $mail->SMTPAuth = true;
                        $mail->Username = $conf['smtp']['username'];
                        $mail->Password = $conf['smtp']['password'];
                        $mail->SMTPSecure = $conf['smtp']['secure'];
                        $mail->Port = $conf['smtp']['port'];
                        $mail->setFrom($conf['from']['email'], $conf['from']['name']);
                        $mail->addAddress($email, $name);
                        $mail->isHTML(true);
                        $token = md5($contact_id . ($conf['unsubscribe_secret'] ?? 'secret_key'));
                        $confirm_url = $conf['base_url'] . '/public/confirm_subscribe.php?cid=' . $contact_id . '&token=' . $token;
                        $mail->Subject = 'Confirm your subscription';
                        $mail->Body = "<p>Hello " . htmlspecialchars($name) . ",</p><p>Please confirm your subscription by clicking the link below:</p><p><a href='".$confirm_url."'>Confirm subscription</a></p>";
                        $mail->send();
                    } catch (Exception $e) {
                        // ignore send errors for now
                    }
                }
            }
        }
        fclose($csv);
        $msg = "Uploaded $count contacts" . ($double_optin ? ' (confirmation emails sent)' : '');
    }
}
$lists = $pdo->query('SELECT * FROM lists')->fetchAll();
?>
<!doctype html>
<html><head><meta charset="utf-8"><title>Lists</title><link rel="stylesheet" href="/assets/css/style.css"></head><body>
<nav class="top"><a href="dashboard.php">Dashboard</a> | <a href="contacts.php">Contacts</a></nav>
<div class="container">
    <h1>Lists</h1>
    <?php if($msg):?><div class="info"><?php echo $msg;?></div><?php endif;?>
    <form method="post">
        <label>New List Name</label><input name="name" required>
        <button name="create_list" class="btn">Create List</button>
    </form>
    <h3>Upload CSV to List</h3>
    <form method="post" enctype="multipart/form-data">
        <label>Select List</label>
        <select name="list_id"><?php foreach($lists as $l){echo "<option value='{$l['id']}'>".htmlspecialchars($l['name'])."</option>";}?></select>
        <label>CSV file (email,name)</label><input type="file" name="csv" accept=".csv" required>
        <label><input type="checkbox" name="double_optin" value="1"> Use double opt-in (send confirmation emails)</label>
        <button name="upload_csv" class="btn">Upload CSV</button>
    </form>
    <h3>Existing Lists</h3>
    <ul><?php foreach($lists as $l){ echo "<li>".htmlspecialchars($l['name'])." - <a href='contacts.php?list={$l['id']}'>View Contacts</a></li>";}?></ul>
</div></body></html>
