<?php
// Simple worker script to send campaign emails in batches.
require __DIR__ . '/config.php';
require __DIR__ . '/vendor/autoload.php';
use PHPMailer\PHPMailer\PHPMailer;

$conf = get_config();
$pdo = get_pdo();

// get next campaign in sending status (or set draft to sending when requested)
$campaign_id = $argv[1] ?? null;
if (!$campaign_id) {
    echo "Usage: php send_worker.php CAMPAIGN_ID\n";
    exit;
}
$campaign_id = intval($campaign_id);
// load campaign
$stmt = $pdo->prepare("SELECT c.*, t.html as template_html FROM campaigns c LEFT JOIN templates t ON t.id=c.template_id WHERE c.id=?");
$stmt->execute([$campaign_id]);
$campaign = $stmt->fetch(PDO::FETCH_ASSOC);
if (!$campaign) { echo "Campaign not found\n"; exit; }

// mark sending
$pdo->prepare("UPDATE campaigns SET status='sending' WHERE id=?")->execute([$campaign_id]);

// fetch batch of pending contacts (only those not unsubscribed or bounced)
$stmt = $pdo->prepare("SELECT lc.* FROM list_contacts lc WHERE lc.list_id=? AND lc.unsubscribed=0 AND lc.bounced=0");
$stmt->execute([$campaign['list_id']]);
$contacts = $stmt->fetchAll(PDO::FETCH_ASSOC);

$mail = new PHPMailer(true);
$mail->isSMTP();
$mail->Host = $conf['smtp']['host'];
$mail->SMTPAuth = true;
$mail->Username = $conf['smtp']['username'];
$mail->Password = $conf['smtp']['password'];
$mail->SMTPSecure = $conf['smtp']['secure'];
$mail->Port = $conf['smtp']['port'];
$mail->setFrom($conf['from']['email'], $conf['from']['name']);

foreach ($contacts as $c) {
    try {
        $personal_html = $campaign['template_html'];
        // personalize simple tokens: [[NAME]]
        $personal_html = str_replace('[[NAME]]', htmlspecialchars($c['name'] ?: ''), $personal_html);
        // add tracking pixel and unsubscribe link
        $track_url = $conf['base_url'] . '/public/track.php?c=' . $campaign_id . '&cid=' . $c['id'];
        $unsubscribe_token = md5($c['id'] . ($conf['unsubscribe_secret'] ?? 'secret_key'));
        $unsubscribe_url = $conf['base_url'] . '/public/unsubscribe.php?cid=' . $c['id'] . '&token=' . $unsubscribe_token;
        $personal_html .= '<img src="' . $track_url . '" width="1" height="1" style="display:none;"/>';
        $personal_html .= '<p><a href="' . $unsubscribe_url . '">Unsubscribe</a></p>';

        $mail->clearAllRecipients();
        $mail->addAddress($c['email'], $c['name']);
        $mail->isHTML(true);
                // Add List-Unsubscribe header pointing to unsubscribe link (use confirmation flow)
                $mail->addCustomHeader('List-Unsubscribe', '<' . $unsubscribe_url . '>');
        $mail->Subject = $campaign['subject'];
        $mail->Body = $personal_html;

        $mail->send();
        // log
        $stmt = $pdo->prepare("INSERT INTO campaign_logs (campaign_id, contact_id, status) VALUES (?,?,?)");
        $stmt->execute([$campaign_id, $c['id'], 'sent']);
    } catch (Exception $e) {
        $stmt = $pdo->prepare("INSERT INTO campaign_logs (campaign_id, contact_id, status) VALUES (?,?,?)");
        $stmt->execute([$campaign_id, $c['id'], 'failed']);
    }
}

// update campaign counts
$total = count($contacts);
$pdo->prepare("UPDATE campaigns SET status='sent', total=?, sent=? WHERE id=?")->execute([$total, $total, $campaign_id]);
echo "Done. Sent: $total\n";
