<?php
use Aws\Ses\SesClient;
use Aws\Exception\AwsException;

require_once __DIR__ . '/../vendor/autoload.php'; // ensure composer install in project root

if (!function_exists('send_ses_mail')) {
function send_ses_mail($conf, $to_email, $to_name, $subject, $html_body) {
    // Read credentials from config if present
    $aws = $conf['aws']['ses'] ?? [
        'region'=>'us-east-1',
        'key'=>'YOUR_AWS_ACCESS_KEY',
        'secret'=>'YOUR_AWS_SECRET_KEY'
    ];

    try {
        $SesClient = new SesClient([
            'version' => '2010-12-01',
            'region'  => $aws['region'],
            'credentials' => [
                'key'    => $aws['key'],
                'secret' => $aws['secret'],
            ],
        ]);

        $result = $SesClient->sendEmail([
            'Source' => $conf['from']['email'],
            'Destination' => [
                'ToAddresses' => [$to_email],
            ],
            'Message' => [
                'Subject' => [
                    'Data' => $subject,
                    'Charset' => 'UTF-8',
                ],
                'Body' => [
                    'Html' => [
                        'Data' => $html_body,
                        'Charset' => 'UTF-8',
                    ],
                ],
            ],
        ]);

        // return true on success
        return true;
    } catch (AwsException $e) {
        // log error
        error_log("[SES ERROR] ".$e->getAwsErrorMessage());
        return false;
    }
}
}
?>