<?php
session_start();
require __DIR__ . '/../config.php';
if (!isset($_SESSION['admin_id'])) {
    header('Location: login.php');
    exit;
}

$pdo = get_pdo();

// ✅ CSV Export
if (isset($_GET['export_campaign']) && intval($_GET['export_campaign'])) {
    $cid = intval($_GET['export_campaign']);
    $stmt = $pdo->prepare('SELECT cl.*, lc.email, lc.name FROM campaign_logs cl LEFT JOIN list_contacts lc ON lc.id=cl.contact_id WHERE cl.campaign_id=?');
    $stmt->execute([$cid]);
    $rows = $stmt->fetchAll();

    header('Content-Type: text/csv');
    header('Content-Disposition: attachment; filename="campaign_' . $cid . '_logs.csv"');
    $out = fopen('php://output', 'w');
    fputcsv($out, ['contact_id', 'email', 'name', 'status', 'opened', 'unsubscribed', 'created_at']);
    foreach ($rows as $r) {
        fputcsv($out, [$r['contact_id'], $r['email'], $r['name'], $r['status'], $r['opened'], $r['unsubscribed'], $r['created_at']]);
    }
    fclose($out);
    exit;
}

$campaigns = $pdo->query('SELECT * FROM campaigns ORDER BY created_at DESC')->fetchAll();
?>
<!doctype html>
<html lang="en">
<head>
<meta charset="utf-8">
<title>Reports - Admin Panel</title>
<style>
* { box-sizing: border-box; margin: 0; padding: 0; }
body {
  font-family: "Inter", Arial, sans-serif;
  background: #f3f4f6;
  color: #333;
  min-height: 100vh;
}

/* ===== Sidebar ===== */
.sidebar {
  position: fixed;
  top: 0;
  left: 0;
  width: 240px;
  height: 100vh;
  background: #fff;
  border-right: 1px solid #ddd;
  padding: 20px;
  overflow-y: auto;
}

.sidebar h3 {
  color: #0d6efd;
  margin-bottom: 20px;
  font-size: 22px;
}

.sidebar a {
  display: block;
  padding: 10px 14px;
  color: #333;
  text-decoration: none;
  border-radius: 6px;
  font-weight: 500;
  margin-bottom: 5px;
  transition: 0.2s;
}

.sidebar a:hover,
.sidebar a.active {
  background: #0d6efd;
  color: #fff;
}

/* ===== Header ===== */
header {
  position: fixed;
  top: 0;
  left: 240px;
  right: 0;
  height: 60px;
  background: #0d6efd;
  color: #fff;
  display: flex;
  align-items: center;
  justify-content: space-between;
  padding: 0 25px;
  z-index: 1000;
  box-shadow: 0 2px 4px rgba(0,0,0,0.1);
}

header h1 {
  font-size: 18px;
}

/* ===== Main Body ===== */
.main {
  margin-left: 240px;
  padding: 80px 25px 25px 25px;
}

/* ===== Container ===== */
.container {
  background: #fff;
  padding: 25px;
  border-radius: 10px;
  box-shadow: 0 2px 8px rgba(0,0,0,0.05);
}

/* ===== Campaign Cards ===== */
.campaign-card {
  border: 1px solid #eee;
  padding: 15px 20px;
  margin-bottom: 12px;
  border-radius: 8px;
  background: #fafafa;
  transition: box-shadow 0.2s;
}
.campaign-card:hover {
  box-shadow: 0 2px 8px rgba(0,0,0,0.05);
}

.campaign-card h3 {
  color: #0d6efd;
  margin-bottom: 5px;
  font-size: 18px;
}

.campaign-card p {
  margin: 5px 0;
  font-size: 14px;
  color: #555;
}

.btn {
  display: inline-block;
  background: #0d6efd;
  color: #fff;
  padding: 6px 12px;
  border-radius: 5px;
  text-decoration: none;
  font-size: 14px;
  transition: background 0.2s;
}

.btn:hover {
  background: #0b5ed7;
}
</style>
</head>
<body>

<!-- Sidebar -->
<nav class="sidebar">
  <h3>Admin Panel</h3>
  <a href="dashboard.php">Dashboard</a>
  <a href="lists.php">Lists</a>
  <a href="templates.php">Templates</a>
  <a href="campaigns.php">Campaigns</a>
  <a href="reports.php" class="active">Reports</a>
  <a href="contacts.php"> Contacts</a>
  <a href="logout.php">Logout</a>
</nav>

<!-- Header -->
<header>
  <h1>Campaign Reports</h1>
  <a href="logout.php" style="color:#fff;text-decoration:none;">Logout</a>
</header>

<!-- Main Body -->
<div class="main">
  <div class="container">
    <h2 style="color:#0d6efd;margin-bottom:15px;">Reports Summary</h2>
    <?php foreach ($campaigns as $c): 
      $stats = $pdo->prepare('SELECT COUNT(*) as total, SUM(opened) as opens, SUM(unsubscribed) as unsub FROM campaign_logs WHERE campaign_id=?');
      $stats->execute([$c['id']]);
      $s = $stats->fetch();
    ?>
      <div class="campaign-card">
        <h3><?= htmlspecialchars($c['name']) ?></h3>
       <?php
$sent = $s['total'] ?: 0;
$opened = $s['opens'] ?: 0;
$unsub = $s['unsub'] ?: 0;
?>
<p><strong>Sent:</strong> <?= $sent ?></p>
<p><strong>Opened:</strong> <?= $opened ?></p>
<p><strong>Unsubscribed:</strong> <?= $unsub ?></p>

        <a class="btn" href="reports.php?export_campaign=<?= $c['id'] ?>"> Export CSV</a>
      </div>
    <?php endforeach; ?>
  </div>
</div>

</body>
</html>
