<?php
use Aws\Ses\SesClient;
use Aws\Exception\AwsException;

// Load the Composer autoloader correctly
require_once '/home/accountsbook/public_html/vendor/autoload.php';


if (!function_exists('send_ses_mail')) {
function send_ses_mail($conf, $to_email, $to_name, $subject, $html_body) {
    // Read credentials from config if present
    $aws = $conf['aws']['ses'] ?? [
        'region'=>'us-east-1',
        'key'=>'AKIAWG5UMZF72FF33OM3',
        'secret'=>'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'
    ];

    try {
        $SesClient = new SesClient([
            'version' => '2010-12-01',
            'region'  => $aws['region'],
            'credentials' => [
                'key'    => $aws['key'],
                'secret' => $aws['secret'],
            ],
        ]);

        $result = $SesClient->sendEmail([
            'Source' => $conf['from']['email'],
            'Destination' => [
                'ToAddresses' => [$to_email],
            ],
            'Message' => [
                'Subject' => [
                    'Data' => $subject,
                    'Charset' => 'UTF-8',
                ],
                'Body' => [
                    'Html' => [
                        'Data' => $html_body,
                        'Charset' => 'UTF-8',
                    ],
                ],
            ],
        ]);

        // return true on success
        return true;
    } catch (AwsException $e) {
        // log error
        error_log("[SES ERROR] ".$e->getAwsErrorMessage());
        return false;
    }
}
}
?>