<?php
// This file was auto-generated from sdk-root/src/data/customer-profiles/2020-08-15/api-2.json
return [ 'version' => '2.0', 'metadata' => [ 'apiVersion' => '2020-08-15', 'endpointPrefix' => 'profile', 'jsonVersion' => '1.1', 'protocol' => 'rest-json', 'protocols' => [ 'rest-json', ], 'serviceAbbreviation' => 'Customer Profiles', 'serviceFullName' => 'Amazon Connect Customer Profiles', 'serviceId' => 'Customer Profiles', 'signatureVersion' => 'v4', 'signingName' => 'profile', 'uid' => 'customer-profiles-2020-08-15', 'auth' => [ 'aws.auth#sigv4', ], ], 'operations' => [ 'AddProfileKey' => [ 'name' => 'AddProfileKey', 'http' => [ 'method' => 'POST', 'requestUri' => '/domains/{DomainName}/profiles/keys', ], 'input' => [ 'shape' => 'AddProfileKeyRequest', ], 'output' => [ 'shape' => 'AddProfileKeyResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'BatchGetCalculatedAttributeForProfile' => [ 'name' => 'BatchGetCalculatedAttributeForProfile', 'http' => [ 'method' => 'POST', 'requestUri' => '/domains/{DomainName}/calculated-attributes/{CalculatedAttributeName}/batch-get-for-profiles', ], 'input' => [ 'shape' => 'BatchGetCalculatedAttributeForProfileRequest', ], 'output' => [ 'shape' => 'BatchGetCalculatedAttributeForProfileResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'BatchGetProfile' => [ 'name' => 'BatchGetProfile', 'http' => [ 'method' => 'POST', 'requestUri' => '/domains/{DomainName}/batch-get-profiles', ], 'input' => [ 'shape' => 'BatchGetProfileRequest', ], 'output' => [ 'shape' => 'BatchGetProfileResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'CreateCalculatedAttributeDefinition' => [ 'name' => 'CreateCalculatedAttributeDefinition', 'http' => [ 'method' => 'POST', 'requestUri' => '/domains/{DomainName}/calculated-attributes/{CalculatedAttributeName}', ], 'input' => [ 'shape' => 'CreateCalculatedAttributeDefinitionRequest', ], 'output' => [ 'shape' => 'CreateCalculatedAttributeDefinitionResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'CreateDomain' => [ 'name' => 'CreateDomain', 'http' => [ 'method' => 'POST', 'requestUri' => '/domains/{DomainName}', ], 'input' => [ 'shape' => 'CreateDomainRequest', ], 'output' => [ 'shape' => 'CreateDomainResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'CreateDomainLayout' => [ 'name' => 'CreateDomainLayout', 'http' => [ 'method' => 'POST', 'requestUri' => '/domains/{DomainName}/layouts/{LayoutDefinitionName}', ], 'input' => [ 'shape' => 'CreateDomainLayoutRequest', ], 'output' => [ 'shape' => 'CreateDomainLayoutResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'CreateEventStream' => [ 'name' => 'CreateEventStream', 'http' => [ 'method' => 'POST', 'requestUri' => '/domains/{DomainName}/event-streams/{EventStreamName}', ], 'input' => [ 'shape' => 'CreateEventStreamRequest', ], 'output' => [ 'shape' => 'CreateEventStreamResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'CreateEventTrigger' => [ 'name' => 'CreateEventTrigger', 'http' => [ 'method' => 'POST', 'requestUri' => '/domains/{DomainName}/event-triggers/{EventTriggerName}', ], 'input' => [ 'shape' => 'CreateEventTriggerRequest', ], 'output' => [ 'shape' => 'CreateEventTriggerResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'CreateIntegrationWorkflow' => [ 'name' => 'CreateIntegrationWorkflow', 'http' => [ 'method' => 'POST', 'requestUri' => '/domains/{DomainName}/workflows/integrations', ], 'input' => [ 'shape' => 'CreateIntegrationWorkflowRequest', ], 'output' => [ 'shape' => 'CreateIntegrationWorkflowResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'CreateProfile' => [ 'name' => 'CreateProfile', 'http' => [ 'method' => 'POST', 'requestUri' => '/domains/{DomainName}/profiles', ], 'input' => [ 'shape' => 'CreateProfileRequest', ], 'output' => [ 'shape' => 'CreateProfileResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'CreateSegmentDefinition' => [ 'name' => 'CreateSegmentDefinition', 'http' => [ 'method' => 'POST', 'requestUri' => '/domains/{DomainName}/segment-definitions/{SegmentDefinitionName}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateSegmentDefinitionRequest', ], 'output' => [ 'shape' => 'CreateSegmentDefinitionResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], 'idempotent' => true, ], 'CreateSegmentEstimate' => [ 'name' => 'CreateSegmentEstimate', 'http' => [ 'method' => 'POST', 'requestUri' => '/domains/{DomainName}/segment-estimates', ], 'input' => [ 'shape' => 'CreateSegmentEstimateRequest', ], 'output' => [ 'shape' => 'CreateSegmentEstimateResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'CreateSegmentSnapshot' => [ 'name' => 'CreateSegmentSnapshot', 'http' => [ 'method' => 'POST', 'requestUri' => '/domains/{DomainName}/segments/{SegmentDefinitionName}/snapshots', ], 'input' => [ 'shape' => 'CreateSegmentSnapshotRequest', ], 'output' => [ 'shape' => 'CreateSegmentSnapshotResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'CreateUploadJob' => [ 'name' => 'CreateUploadJob', 'http' => [ 'method' => 'POST', 'requestUri' => '/domains/{DomainName}/upload-jobs', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateUploadJobRequest', ], 'output' => [ 'shape' => 'CreateUploadJobResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], ], 'DeleteCalculatedAttributeDefinition' => [ 'name' => 'DeleteCalculatedAttributeDefinition', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/domains/{DomainName}/calculated-attributes/{CalculatedAttributeName}', ], 'input' => [ 'shape' => 'DeleteCalculatedAttributeDefinitionRequest', ], 'output' => [ 'shape' => 'DeleteCalculatedAttributeDefinitionResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'DeleteDomain' => [ 'name' => 'DeleteDomain', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/domains/{DomainName}', ], 'input' => [ 'shape' => 'DeleteDomainRequest', ], 'output' => [ 'shape' => 'DeleteDomainResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'DeleteDomainLayout' => [ 'name' => 'DeleteDomainLayout', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/domains/{DomainName}/layouts/{LayoutDefinitionName}', ], 'input' => [ 'shape' => 'DeleteDomainLayoutRequest', ], 'output' => [ 'shape' => 'DeleteDomainLayoutResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'DeleteEventStream' => [ 'name' => 'DeleteEventStream', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/domains/{DomainName}/event-streams/{EventStreamName}', ], 'input' => [ 'shape' => 'DeleteEventStreamRequest', ], 'output' => [ 'shape' => 'DeleteEventStreamResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], 'idempotent' => true, ], 'DeleteEventTrigger' => [ 'name' => 'DeleteEventTrigger', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/domains/{DomainName}/event-triggers/{EventTriggerName}', ], 'input' => [ 'shape' => 'DeleteEventTriggerRequest', ], 'output' => [ 'shape' => 'DeleteEventTriggerResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'DeleteIntegration' => [ 'name' => 'DeleteIntegration', 'http' => [ 'method' => 'POST', 'requestUri' => '/domains/{DomainName}/integrations/delete', ], 'input' => [ 'shape' => 'DeleteIntegrationRequest', ], 'output' => [ 'shape' => 'DeleteIntegrationResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'DeleteProfile' => [ 'name' => 'DeleteProfile', 'http' => [ 'method' => 'POST', 'requestUri' => '/domains/{DomainName}/profiles/delete', ], 'input' => [ 'shape' => 'DeleteProfileRequest', ], 'output' => [ 'shape' => 'DeleteProfileResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'DeleteProfileKey' => [ 'name' => 'DeleteProfileKey', 'http' => [ 'method' => 'POST', 'requestUri' => '/domains/{DomainName}/profiles/keys/delete', ], 'input' => [ 'shape' => 'DeleteProfileKeyRequest', ], 'output' => [ 'shape' => 'DeleteProfileKeyResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'DeleteProfileObject' => [ 'name' => 'DeleteProfileObject', 'http' => [ 'method' => 'POST', 'requestUri' => '/domains/{DomainName}/profiles/objects/delete', ], 'input' => [ 'shape' => 'DeleteProfileObjectRequest', ], 'output' => [ 'shape' => 'DeleteProfileObjectResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'DeleteProfileObjectType' => [ 'name' => 'DeleteProfileObjectType', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/domains/{DomainName}/object-types/{ObjectTypeName}', ], 'input' => [ 'shape' => 'DeleteProfileObjectTypeRequest', ], 'output' => [ 'shape' => 'DeleteProfileObjectTypeResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'DeleteSegmentDefinition' => [ 'name' => 'DeleteSegmentDefinition', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/domains/{DomainName}/segment-definitions/{SegmentDefinitionName}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DeleteSegmentDefinitionRequest', ], 'output' => [ 'shape' => 'DeleteSegmentDefinitionResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], 'idempotent' => true, ], 'DeleteWorkflow' => [ 'name' => 'DeleteWorkflow', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/domains/{DomainName}/workflows/{WorkflowId}', ], 'input' => [ 'shape' => 'DeleteWorkflowRequest', ], 'output' => [ 'shape' => 'DeleteWorkflowResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'DetectProfileObjectType' => [ 'name' => 'DetectProfileObjectType', 'http' => [ 'method' => 'POST', 'requestUri' => '/domains/{DomainName}/detect/object-types', ], 'input' => [ 'shape' => 'DetectProfileObjectTypeRequest', ], 'output' => [ 'shape' => 'DetectProfileObjectTypeResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'GetAutoMergingPreview' => [ 'name' => 'GetAutoMergingPreview', 'http' => [ 'method' => 'POST', 'requestUri' => '/domains/{DomainName}/identity-resolution-jobs/auto-merging-preview', ], 'input' => [ 'shape' => 'GetAutoMergingPreviewRequest', ], 'output' => [ 'shape' => 'GetAutoMergingPreviewResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'GetCalculatedAttributeDefinition' => [ 'name' => 'GetCalculatedAttributeDefinition', 'http' => [ 'method' => 'GET', 'requestUri' => '/domains/{DomainName}/calculated-attributes/{CalculatedAttributeName}', ], 'input' => [ 'shape' => 'GetCalculatedAttributeDefinitionRequest', ], 'output' => [ 'shape' => 'GetCalculatedAttributeDefinitionResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'GetCalculatedAttributeForProfile' => [ 'name' => 'GetCalculatedAttributeForProfile', 'http' => [ 'method' => 'GET', 'requestUri' => '/domains/{DomainName}/profile/{ProfileId}/calculated-attributes/{CalculatedAttributeName}', ], 'input' => [ 'shape' => 'GetCalculatedAttributeForProfileRequest', ], 'output' => [ 'shape' => 'GetCalculatedAttributeForProfileResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'GetDomain' => [ 'name' => 'GetDomain', 'http' => [ 'method' => 'GET', 'requestUri' => '/domains/{DomainName}', ], 'input' => [ 'shape' => 'GetDomainRequest', ], 'output' => [ 'shape' => 'GetDomainResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'GetDomainLayout' => [ 'name' => 'GetDomainLayout', 'http' => [ 'method' => 'GET', 'requestUri' => '/domains/{DomainName}/layouts/{LayoutDefinitionName}', ], 'input' => [ 'shape' => 'GetDomainLayoutRequest', ], 'output' => [ 'shape' => 'GetDomainLayoutResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'GetEventStream' => [ 'name' => 'GetEventStream', 'http' => [ 'method' => 'GET', 'requestUri' => '/domains/{DomainName}/event-streams/{EventStreamName}', ], 'input' => [ 'shape' => 'GetEventStreamRequest', ], 'output' => [ 'shape' => 'GetEventStreamResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'GetEventTrigger' => [ 'name' => 'GetEventTrigger', 'http' => [ 'method' => 'GET', 'requestUri' => '/domains/{DomainName}/event-triggers/{EventTriggerName}', ], 'input' => [ 'shape' => 'GetEventTriggerRequest', ], 'output' => [ 'shape' => 'GetEventTriggerResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'GetIdentityResolutionJob' => [ 'name' => 'GetIdentityResolutionJob', 'http' => [ 'method' => 'GET', 'requestUri' => '/domains/{DomainName}/identity-resolution-jobs/{JobId}', ], 'input' => [ 'shape' => 'GetIdentityResolutionJobRequest', ], 'output' => [ 'shape' => 'GetIdentityResolutionJobResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'GetIntegration' => [ 'name' => 'GetIntegration', 'http' => [ 'method' => 'POST', 'requestUri' => '/domains/{DomainName}/integrations', ], 'input' => [ 'shape' => 'GetIntegrationRequest', ], 'output' => [ 'shape' => 'GetIntegrationResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'GetMatches' => [ 'name' => 'GetMatches', 'http' => [ 'method' => 'GET', 'requestUri' => '/domains/{DomainName}/matches', ], 'input' => [ 'shape' => 'GetMatchesRequest', ], 'output' => [ 'shape' => 'GetMatchesResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'GetProfileHistoryRecord' => [ 'name' => 'GetProfileHistoryRecord', 'http' => [ 'method' => 'GET', 'requestUri' => '/domains/{DomainName}/profiles/{ProfileId}/history-records/{Id}', ], 'input' => [ 'shape' => 'GetProfileHistoryRecordRequest', ], 'output' => [ 'shape' => 'GetProfileHistoryRecordResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'GetProfileObjectType' => [ 'name' => 'GetProfileObjectType', 'http' => [ 'method' => 'GET', 'requestUri' => '/domains/{DomainName}/object-types/{ObjectTypeName}', ], 'input' => [ 'shape' => 'GetProfileObjectTypeRequest', ], 'output' => [ 'shape' => 'GetProfileObjectTypeResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'GetProfileObjectTypeTemplate' => [ 'name' => 'GetProfileObjectTypeTemplate', 'http' => [ 'method' => 'GET', 'requestUri' => '/templates/{TemplateId}', ], 'input' => [ 'shape' => 'GetProfileObjectTypeTemplateRequest', ], 'output' => [ 'shape' => 'GetProfileObjectTypeTemplateResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'GetSegmentDefinition' => [ 'name' => 'GetSegmentDefinition', 'http' => [ 'method' => 'GET', 'requestUri' => '/domains/{DomainName}/segment-definitions/{SegmentDefinitionName}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetSegmentDefinitionRequest', ], 'output' => [ 'shape' => 'GetSegmentDefinitionResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], 'readonly' => true, ], 'GetSegmentEstimate' => [ 'name' => 'GetSegmentEstimate', 'http' => [ 'method' => 'GET', 'requestUri' => '/domains/{DomainName}/segment-estimates/{EstimateId}', ], 'input' => [ 'shape' => 'GetSegmentEstimateRequest', ], 'output' => [ 'shape' => 'GetSegmentEstimateResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'GetSegmentMembership' => [ 'name' => 'GetSegmentMembership', 'http' => [ 'method' => 'POST', 'requestUri' => '/domains/{DomainName}/segments/{SegmentDefinitionName}/membership', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetSegmentMembershipRequest', ], 'output' => [ 'shape' => 'GetSegmentMembershipResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], 'idempotent' => true, ], 'GetSegmentSnapshot' => [ 'name' => 'GetSegmentSnapshot', 'http' => [ 'method' => 'GET', 'requestUri' => '/domains/{DomainName}/segments/{SegmentDefinitionName}/snapshots/{SnapshotId}', ], 'input' => [ 'shape' => 'GetSegmentSnapshotRequest', ], 'output' => [ 'shape' => 'GetSegmentSnapshotResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'GetSimilarProfiles' => [ 'name' => 'GetSimilarProfiles', 'http' => [ 'method' => 'POST', 'requestUri' => '/domains/{DomainName}/matches', ], 'input' => [ 'shape' => 'GetSimilarProfilesRequest', ], 'output' => [ 'shape' => 'GetSimilarProfilesResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'GetUploadJob' => [ 'name' => 'GetUploadJob', 'http' => [ 'method' => 'GET', 'requestUri' => '/domains/{DomainName}/upload-jobs/{JobId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetUploadJobRequest', ], 'output' => [ 'shape' => 'GetUploadJobResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], 'readonly' => true, ], 'GetUploadJobPath' => [ 'name' => 'GetUploadJobPath', 'http' => [ 'method' => 'GET', 'requestUri' => '/domains/{DomainName}/upload-jobs/{JobId}/path', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetUploadJobPathRequest', ], 'output' => [ 'shape' => 'GetUploadJobPathResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], 'readonly' => true, ], 'GetWorkflow' => [ 'name' => 'GetWorkflow', 'http' => [ 'method' => 'GET', 'requestUri' => '/domains/{DomainName}/workflows/{WorkflowId}', ], 'input' => [ 'shape' => 'GetWorkflowRequest', ], 'output' => [ 'shape' => 'GetWorkflowResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'GetWorkflowSteps' => [ 'name' => 'GetWorkflowSteps', 'http' => [ 'method' => 'GET', 'requestUri' => '/domains/{DomainName}/workflows/{WorkflowId}/steps', ], 'input' => [ 'shape' => 'GetWorkflowStepsRequest', ], 'output' => [ 'shape' => 'GetWorkflowStepsResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'ListAccountIntegrations' => [ 'name' => 'ListAccountIntegrations', 'http' => [ 'method' => 'POST', 'requestUri' => '/integrations', ], 'input' => [ 'shape' => 'ListAccountIntegrationsRequest', ], 'output' => [ 'shape' => 'ListAccountIntegrationsResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'ListCalculatedAttributeDefinitions' => [ 'name' => 'ListCalculatedAttributeDefinitions', 'http' => [ 'method' => 'GET', 'requestUri' => '/domains/{DomainName}/calculated-attributes', ], 'input' => [ 'shape' => 'ListCalculatedAttributeDefinitionsRequest', ], 'output' => [ 'shape' => 'ListCalculatedAttributeDefinitionsResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'ListCalculatedAttributesForProfile' => [ 'name' => 'ListCalculatedAttributesForProfile', 'http' => [ 'method' => 'GET', 'requestUri' => '/domains/{DomainName}/profile/{ProfileId}/calculated-attributes', ], 'input' => [ 'shape' => 'ListCalculatedAttributesForProfileRequest', ], 'output' => [ 'shape' => 'ListCalculatedAttributesForProfileResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'ListDomainLayouts' => [ 'name' => 'ListDomainLayouts', 'http' => [ 'method' => 'GET', 'requestUri' => '/domains/{DomainName}/layouts', ], 'input' => [ 'shape' => 'ListDomainLayoutsRequest', ], 'output' => [ 'shape' => 'ListDomainLayoutsResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'ListDomains' => [ 'name' => 'ListDomains', 'http' => [ 'method' => 'GET', 'requestUri' => '/domains', ], 'input' => [ 'shape' => 'ListDomainsRequest', ], 'output' => [ 'shape' => 'ListDomainsResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'ListEventStreams' => [ 'name' => 'ListEventStreams', 'http' => [ 'method' => 'GET', 'requestUri' => '/domains/{DomainName}/event-streams', ], 'input' => [ 'shape' => 'ListEventStreamsRequest', ], 'output' => [ 'shape' => 'ListEventStreamsResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'ListEventTriggers' => [ 'name' => 'ListEventTriggers', 'http' => [ 'method' => 'GET', 'requestUri' => '/domains/{DomainName}/event-triggers', ], 'input' => [ 'shape' => 'ListEventTriggersRequest', ], 'output' => [ 'shape' => 'ListEventTriggersResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'ListIdentityResolutionJobs' => [ 'name' => 'ListIdentityResolutionJobs', 'http' => [ 'method' => 'GET', 'requestUri' => '/domains/{DomainName}/identity-resolution-jobs', ], 'input' => [ 'shape' => 'ListIdentityResolutionJobsRequest', ], 'output' => [ 'shape' => 'ListIdentityResolutionJobsResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'ListIntegrations' => [ 'name' => 'ListIntegrations', 'http' => [ 'method' => 'GET', 'requestUri' => '/domains/{DomainName}/integrations', ], 'input' => [ 'shape' => 'ListIntegrationsRequest', ], 'output' => [ 'shape' => 'ListIntegrationsResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'ListObjectTypeAttributes' => [ 'name' => 'ListObjectTypeAttributes', 'http' => [ 'method' => 'GET', 'requestUri' => '/domains/{DomainName}/object-types/{ObjectTypeName}/attributes', ], 'input' => [ 'shape' => 'ListObjectTypeAttributesRequest', ], 'output' => [ 'shape' => 'ListObjectTypeAttributesResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'ListProfileAttributeValues' => [ 'name' => 'ListProfileAttributeValues', 'http' => [ 'method' => 'GET', 'requestUri' => '/domains/{DomainName}/profile-attributes/{AttributeName}/values', ], 'input' => [ 'shape' => 'ProfileAttributeValuesRequest', ], 'output' => [ 'shape' => 'ProfileAttributeValuesResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'ListProfileHistoryRecords' => [ 'name' => 'ListProfileHistoryRecords', 'http' => [ 'method' => 'POST', 'requestUri' => '/domains/{DomainName}/profiles/history-records', ], 'input' => [ 'shape' => 'ListProfileHistoryRecordsRequest', ], 'output' => [ 'shape' => 'ListProfileHistoryRecordsResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'ListProfileObjectTypeTemplates' => [ 'name' => 'ListProfileObjectTypeTemplates', 'http' => [ 'method' => 'GET', 'requestUri' => '/templates', ], 'input' => [ 'shape' => 'ListProfileObjectTypeTemplatesRequest', ], 'output' => [ 'shape' => 'ListProfileObjectTypeTemplatesResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'ListProfileObjectTypes' => [ 'name' => 'ListProfileObjectTypes', 'http' => [ 'method' => 'GET', 'requestUri' => '/domains/{DomainName}/object-types', ], 'input' => [ 'shape' => 'ListProfileObjectTypesRequest', ], 'output' => [ 'shape' => 'ListProfileObjectTypesResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'ListProfileObjects' => [ 'name' => 'ListProfileObjects', 'http' => [ 'method' => 'POST', 'requestUri' => '/domains/{DomainName}/profiles/objects', ], 'input' => [ 'shape' => 'ListProfileObjectsRequest', ], 'output' => [ 'shape' => 'ListProfileObjectsResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'ListRuleBasedMatches' => [ 'name' => 'ListRuleBasedMatches', 'http' => [ 'method' => 'GET', 'requestUri' => '/domains/{DomainName}/profiles/ruleBasedMatches', ], 'input' => [ 'shape' => 'ListRuleBasedMatchesRequest', ], 'output' => [ 'shape' => 'ListRuleBasedMatchesResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'ListSegmentDefinitions' => [ 'name' => 'ListSegmentDefinitions', 'http' => [ 'method' => 'GET', 'requestUri' => '/domains/{DomainName}/segment-definitions', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListSegmentDefinitionsRequest', ], 'output' => [ 'shape' => 'ListSegmentDefinitionsResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], 'readonly' => true, ], 'ListTagsForResource' => [ 'name' => 'ListTagsForResource', 'http' => [ 'method' => 'GET', 'requestUri' => '/tags/{resourceArn}', ], 'input' => [ 'shape' => 'ListTagsForResourceRequest', ], 'output' => [ 'shape' => 'ListTagsForResourceResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'ListUploadJobs' => [ 'name' => 'ListUploadJobs', 'http' => [ 'method' => 'GET', 'requestUri' => '/domains/{DomainName}/upload-jobs', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListUploadJobsRequest', ], 'output' => [ 'shape' => 'ListUploadJobsResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], 'readonly' => true, ], 'ListWorkflows' => [ 'name' => 'ListWorkflows', 'http' => [ 'method' => 'POST', 'requestUri' => '/domains/{DomainName}/workflows', ], 'input' => [ 'shape' => 'ListWorkflowsRequest', ], 'output' => [ 'shape' => 'ListWorkflowsResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'MergeProfiles' => [ 'name' => 'MergeProfiles', 'http' => [ 'method' => 'POST', 'requestUri' => '/domains/{DomainName}/profiles/objects/merge', ], 'input' => [ 'shape' => 'MergeProfilesRequest', ], 'output' => [ 'shape' => 'MergeProfilesResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'PutIntegration' => [ 'name' => 'PutIntegration', 'http' => [ 'method' => 'PUT', 'requestUri' => '/domains/{DomainName}/integrations', ], 'input' => [ 'shape' => 'PutIntegrationRequest', ], 'output' => [ 'shape' => 'PutIntegrationResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'PutProfileObject' => [ 'name' => 'PutProfileObject', 'http' => [ 'method' => 'PUT', 'requestUri' => '/domains/{DomainName}/profiles/objects', ], 'input' => [ 'shape' => 'PutProfileObjectRequest', ], 'output' => [ 'shape' => 'PutProfileObjectResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'PutProfileObjectType' => [ 'name' => 'PutProfileObjectType', 'http' => [ 'method' => 'PUT', 'requestUri' => '/domains/{DomainName}/object-types/{ObjectTypeName}', ], 'input' => [ 'shape' => 'PutProfileObjectTypeRequest', ], 'output' => [ 'shape' => 'PutProfileObjectTypeResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'SearchProfiles' => [ 'name' => 'SearchProfiles', 'http' => [ 'method' => 'POST', 'requestUri' => '/domains/{DomainName}/profiles/search', ], 'input' => [ 'shape' => 'SearchProfilesRequest', ], 'output' => [ 'shape' => 'SearchProfilesResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'StartUploadJob' => [ 'name' => 'StartUploadJob', 'http' => [ 'method' => 'PUT', 'requestUri' => '/domains/{DomainName}/upload-jobs/{JobId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'StartUploadJobRequest', ], 'output' => [ 'shape' => 'StartUploadJobResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], ], 'StopUploadJob' => [ 'name' => 'StopUploadJob', 'http' => [ 'method' => 'PUT', 'requestUri' => '/domains/{DomainName}/upload-jobs/{JobId}/stop', 'responseCode' => 200, ], 'input' => [ 'shape' => 'StopUploadJobRequest', ], 'output' => [ 'shape' => 'StopUploadJobResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'AccessDeniedException', ], ], ], 'TagResource' => [ 'name' => 'TagResource', 'http' => [ 'method' => 'POST', 'requestUri' => '/tags/{resourceArn}', ], 'input' => [ 'shape' => 'TagResourceRequest', ], 'output' => [ 'shape' => 'TagResourceResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'UntagResource' => [ 'name' => 'UntagResource', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/tags/{resourceArn}', ], 'input' => [ 'shape' => 'UntagResourceRequest', ], 'output' => [ 'shape' => 'UntagResourceResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'UpdateCalculatedAttributeDefinition' => [ 'name' => 'UpdateCalculatedAttributeDefinition', 'http' => [ 'method' => 'PUT', 'requestUri' => '/domains/{DomainName}/calculated-attributes/{CalculatedAttributeName}', ], 'input' => [ 'shape' => 'UpdateCalculatedAttributeDefinitionRequest', ], 'output' => [ 'shape' => 'UpdateCalculatedAttributeDefinitionResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'UpdateDomain' => [ 'name' => 'UpdateDomain', 'http' => [ 'method' => 'PUT', 'requestUri' => '/domains/{DomainName}', ], 'input' => [ 'shape' => 'UpdateDomainRequest', ], 'output' => [ 'shape' => 'UpdateDomainResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'UpdateDomainLayout' => [ 'name' => 'UpdateDomainLayout', 'http' => [ 'method' => 'PUT', 'requestUri' => '/domains/{DomainName}/layouts/{LayoutDefinitionName}', ], 'input' => [ 'shape' => 'UpdateDomainLayoutRequest', ], 'output' => [ 'shape' => 'UpdateDomainLayoutResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'UpdateEventTrigger' => [ 'name' => 'UpdateEventTrigger', 'http' => [ 'method' => 'PUT', 'requestUri' => '/domains/{DomainName}/event-triggers/{EventTriggerName}', ], 'input' => [ 'shape' => 'UpdateEventTriggerRequest', ], 'output' => [ 'shape' => 'UpdateEventTriggerResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], 'UpdateProfile' => [ 'name' => 'UpdateProfile', 'http' => [ 'method' => 'PUT', 'requestUri' => '/domains/{DomainName}/profiles', ], 'input' => [ 'shape' => 'UpdateProfileRequest', ], 'output' => [ 'shape' => 'UpdateProfileResponse', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'InternalServerException', ], ], ], ], 'shapes' => [ 'name' => [ 'type' => 'string', 'max' => 64, 'min' => 1, 'pattern' => '^[a-zA-Z0-9_-]+$', ], 'AccessDeniedException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'message', ], ], 'error' => [ 'httpStatusCode' => 403, ], 'exception' => true, ], 'ActionType' => [ 'type' => 'string', 'enum' => [ 'ADDED_PROFILE_KEY', 'DELETED_PROFILE_KEY', 'CREATED', 'UPDATED', 'INGESTED', 'DELETED_BY_CUSTOMER', 'EXPIRED', 'MERGED', 'DELETED_BY_MERGE', ], ], 'AddProfileKeyRequest' => [ 'type' => 'structure', 'required' => [ 'ProfileId', 'KeyName', 'Values', 'DomainName', ], 'members' => [ 'ProfileId' => [ 'shape' => 'uuid', ], 'KeyName' => [ 'shape' => 'name', ], 'Values' => [ 'shape' => 'requestValueList', ], 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], ], ], 'AddProfileKeyResponse' => [ 'type' => 'structure', 'members' => [ 'KeyName' => [ 'shape' => 'name', ], 'Values' => [ 'shape' => 'requestValueList', ], ], ], 'AdditionalSearchKey' => [ 'type' => 'structure', 'required' => [ 'KeyName', 'Values', ], 'members' => [ 'KeyName' => [ 'shape' => 'name', ], 'Values' => [ 'shape' => 'requestValueList', ], ], ], 'Address' => [ 'type' => 'structure', 'members' => [ 'Address1' => [ 'shape' => 'string1To255', ], 'Address2' => [ 'shape' => 'string1To255', ], 'Address3' => [ 'shape' => 'string1To255', ], 'Address4' => [ 'shape' => 'string1To255', ], 'City' => [ 'shape' => 'string1To255', ], 'County' => [ 'shape' => 'string1To255', ], 'State' => [ 'shape' => 'string1To255', ], 'Province' => [ 'shape' => 'string1To255', ], 'Country' => [ 'shape' => 'string1To255', ], 'PostalCode' => [ 'shape' => 'string1To255', ], ], 'sensitive' => true, ], 'AddressDimension' => [ 'type' => 'structure', 'members' => [ 'City' => [ 'shape' => 'ProfileDimension', 'locationName' => 'City', ], 'Country' => [ 'shape' => 'ProfileDimension', 'locationName' => 'Country', ], 'County' => [ 'shape' => 'ProfileDimension', 'locationName' => 'County', ], 'PostalCode' => [ 'shape' => 'ProfileDimension', 'locationName' => 'PostalCode', ], 'Province' => [ 'shape' => 'ProfileDimension', 'locationName' => 'Province', ], 'State' => [ 'shape' => 'ProfileDimension', 'locationName' => 'State', ], ], ], 'AddressList' => [ 'type' => 'list', 'member' => [ 'shape' => 'string1To255', ], 'max' => 4, 'min' => 1, ], 'AppflowIntegration' => [ 'type' => 'structure', 'required' => [ 'FlowDefinition', ], 'members' => [ 'FlowDefinition' => [ 'shape' => 'FlowDefinition', ], 'Batches' => [ 'shape' => 'Batches', ], ], ], 'AppflowIntegrationWorkflowAttributes' => [ 'type' => 'structure', 'required' => [ 'SourceConnectorType', 'ConnectorProfileName', ], 'members' => [ 'SourceConnectorType' => [ 'shape' => 'SourceConnectorType', ], 'ConnectorProfileName' => [ 'shape' => 'ConnectorProfileName', ], 'RoleArn' => [ 'shape' => 'string1To255', ], ], ], 'AppflowIntegrationWorkflowMetrics' => [ 'type' => 'structure', 'required' => [ 'RecordsProcessed', 'StepsCompleted', 'TotalSteps', ], 'members' => [ 'RecordsProcessed' => [ 'shape' => 'long', ], 'StepsCompleted' => [ 'shape' => 'long', ], 'TotalSteps' => [ 'shape' => 'long', ], ], ], 'AppflowIntegrationWorkflowStep' => [ 'type' => 'structure', 'required' => [ 'FlowName', 'Status', 'ExecutionMessage', 'RecordsProcessed', 'BatchRecordsStartTime', 'BatchRecordsEndTime', 'CreatedAt', 'LastUpdatedAt', ], 'members' => [ 'FlowName' => [ 'shape' => 'FlowName', ], 'Status' => [ 'shape' => 'Status', ], 'ExecutionMessage' => [ 'shape' => 'string1To255', ], 'RecordsProcessed' => [ 'shape' => 'long', ], 'BatchRecordsStartTime' => [ 'shape' => 'string1To255', ], 'BatchRecordsEndTime' => [ 'shape' => 'string1To255', ], 'CreatedAt' => [ 'shape' => 'timestamp', ], 'LastUpdatedAt' => [ 'shape' => 'timestamp', ], ], ], 'AttributeDetails' => [ 'type' => 'structure', 'required' => [ 'Attributes', 'Expression', ], 'members' => [ 'Attributes' => [ 'shape' => 'AttributeList', ], 'Expression' => [ 'shape' => 'string1To255', ], ], 'sensitive' => true, ], 'AttributeDimension' => [ 'type' => 'structure', 'required' => [ 'DimensionType', 'Values', ], 'members' => [ 'DimensionType' => [ 'shape' => 'AttributeDimensionType', 'locationName' => 'DimensionType', ], 'Values' => [ 'shape' => 'Values', 'locationName' => 'Values', ], ], ], 'AttributeDimensionType' => [ 'type' => 'string', 'enum' => [ 'INCLUSIVE', 'EXCLUSIVE', 'CONTAINS', 'BEGINS_WITH', 'ENDS_WITH', 'BEFORE', 'AFTER', 'BETWEEN', 'NOT_BETWEEN', 'ON', 'GREATER_THAN', 'LESS_THAN', 'GREATER_THAN_OR_EQUAL', 'LESS_THAN_OR_EQUAL', 'EQUAL', ], ], 'AttributeItem' => [ 'type' => 'structure', 'required' => [ 'Name', ], 'members' => [ 'Name' => [ 'shape' => 'attributeName', ], ], ], 'AttributeList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AttributeItem', ], 'max' => 50, 'min' => 1, ], 'AttributeMap' => [ 'type' => 'map', 'key' => [ 'shape' => 'attributeName', ], 'value' => [ 'shape' => 'FilterAttributeDimension', ], ], 'AttributeMatchingModel' => [ 'type' => 'string', 'enum' => [ 'ONE_TO_ONE', 'MANY_TO_MANY', ], ], 'AttributeSourceIdMap' => [ 'type' => 'map', 'key' => [ 'shape' => 'string1To255', ], 'value' => [ 'shape' => 'uuid', ], ], 'AttributeTypesSelector' => [ 'type' => 'structure', 'required' => [ 'AttributeMatchingModel', ], 'members' => [ 'AttributeMatchingModel' => [ 'shape' => 'AttributeMatchingModel', ], 'Address' => [ 'shape' => 'AddressList', ], 'PhoneNumber' => [ 'shape' => 'PhoneNumberList', ], 'EmailAddress' => [ 'shape' => 'EmailList', ], ], ], 'AttributeValueItem' => [ 'type' => 'structure', 'members' => [ 'Value' => [ 'shape' => 'string1To255', ], ], ], 'AttributeValueItemList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AttributeValueItem', ], ], 'Attributes' => [ 'type' => 'map', 'key' => [ 'shape' => 'string1To255', ], 'value' => [ 'shape' => 'string1To255', ], 'sensitive' => true, ], 'AutoMerging' => [ 'type' => 'structure', 'required' => [ 'Enabled', ], 'members' => [ 'Enabled' => [ 'shape' => 'optionalBoolean', ], 'Consolidation' => [ 'shape' => 'Consolidation', ], 'ConflictResolution' => [ 'shape' => 'ConflictResolution', ], 'MinAllowedConfidenceScoreForMerging' => [ 'shape' => 'Double0To1', ], ], ], 'BadRequestException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'message', ], ], 'error' => [ 'httpStatusCode' => 400, ], 'exception' => true, ], 'Batch' => [ 'type' => 'structure', 'required' => [ 'StartTime', 'EndTime', ], 'members' => [ 'StartTime' => [ 'shape' => 'timestamp', ], 'EndTime' => [ 'shape' => 'timestamp', ], ], ], 'BatchGetCalculatedAttributeForProfileError' => [ 'type' => 'structure', 'required' => [ 'Code', 'Message', 'ProfileId', ], 'members' => [ 'Code' => [ 'shape' => 'string1To255', ], 'Message' => [ 'shape' => 'string1To1000', ], 'ProfileId' => [ 'shape' => 'uuid', ], ], ], 'BatchGetCalculatedAttributeForProfileErrorList' => [ 'type' => 'list', 'member' => [ 'shape' => 'BatchGetCalculatedAttributeForProfileError', ], ], 'BatchGetCalculatedAttributeForProfileIdList' => [ 'type' => 'list', 'member' => [ 'shape' => 'uuid', ], 'max' => 100, 'min' => 1, ], 'BatchGetCalculatedAttributeForProfileRequest' => [ 'type' => 'structure', 'required' => [ 'CalculatedAttributeName', 'DomainName', 'ProfileIds', ], 'members' => [ 'CalculatedAttributeName' => [ 'shape' => 'typeName', 'location' => 'uri', 'locationName' => 'CalculatedAttributeName', ], 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], 'ProfileIds' => [ 'shape' => 'BatchGetCalculatedAttributeForProfileIdList', ], 'ConditionOverrides' => [ 'shape' => 'ConditionOverrides', ], ], ], 'BatchGetCalculatedAttributeForProfileResponse' => [ 'type' => 'structure', 'members' => [ 'Errors' => [ 'shape' => 'BatchGetCalculatedAttributeForProfileErrorList', ], 'CalculatedAttributeValues' => [ 'shape' => 'CalculatedAttributeValueList', ], 'ConditionOverrides' => [ 'shape' => 'ConditionOverrides', ], ], ], 'BatchGetProfileError' => [ 'type' => 'structure', 'required' => [ 'Code', 'Message', 'ProfileId', ], 'members' => [ 'Code' => [ 'shape' => 'string1To255', ], 'Message' => [ 'shape' => 'string1To1000', ], 'ProfileId' => [ 'shape' => 'uuid', ], ], ], 'BatchGetProfileErrorList' => [ 'type' => 'list', 'member' => [ 'shape' => 'BatchGetProfileError', ], ], 'BatchGetProfileIdList' => [ 'type' => 'list', 'member' => [ 'shape' => 'uuid', ], 'max' => 20, 'min' => 1, ], 'BatchGetProfileRequest' => [ 'type' => 'structure', 'required' => [ 'DomainName', 'ProfileIds', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], 'ProfileIds' => [ 'shape' => 'BatchGetProfileIdList', ], ], ], 'BatchGetProfileResponse' => [ 'type' => 'structure', 'members' => [ 'Errors' => [ 'shape' => 'BatchGetProfileErrorList', ], 'Profiles' => [ 'shape' => 'ProfileList', ], ], ], 'Batches' => [ 'type' => 'list', 'member' => [ 'shape' => 'Batch', ], ], 'BucketName' => [ 'type' => 'string', 'max' => 63, 'min' => 3, 'pattern' => '\\S+', ], 'BucketPrefix' => [ 'type' => 'string', 'max' => 512, 'pattern' => '.*', ], 'CalculatedAttributeDefinitionsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ListCalculatedAttributeDefinitionItem', ], 'sensitive' => true, ], 'CalculatedAttributeDimension' => [ 'type' => 'structure', 'required' => [ 'DimensionType', 'Values', ], 'members' => [ 'DimensionType' => [ 'shape' => 'AttributeDimensionType', 'locationName' => 'DimensionType', ], 'Values' => [ 'shape' => 'Values', 'locationName' => 'Values', ], 'ConditionOverrides' => [ 'shape' => 'ConditionOverrides', 'locationName' => 'ConditionOverrides', ], ], ], 'CalculatedAttributeValue' => [ 'type' => 'structure', 'members' => [ 'CalculatedAttributeName' => [ 'shape' => 'typeName', ], 'DisplayName' => [ 'shape' => 'displayName', ], 'IsDataPartial' => [ 'shape' => 'string1To255', ], 'ProfileId' => [ 'shape' => 'uuid', ], 'Value' => [ 'shape' => 'string1To255', ], 'LastObjectTimestamp' => [ 'shape' => 'timestamp', ], ], ], 'CalculatedAttributeValueList' => [ 'type' => 'list', 'member' => [ 'shape' => 'CalculatedAttributeValue', ], ], 'CalculatedAttributesForProfileList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ListCalculatedAttributeForProfileItem', ], ], 'CalculatedCustomAttributes' => [ 'type' => 'map', 'key' => [ 'shape' => 'typeName', ], 'value' => [ 'shape' => 'CalculatedAttributeDimension', ], ], 'ComparisonOperator' => [ 'type' => 'string', 'enum' => [ 'INCLUSIVE', 'EXCLUSIVE', 'CONTAINS', 'BEGINS_WITH', 'ENDS_WITH', 'GREATER_THAN', 'LESS_THAN', 'GREATER_THAN_OR_EQUAL', 'LESS_THAN_OR_EQUAL', 'EQUAL', 'BEFORE', 'AFTER', 'ON', 'BETWEEN', 'NOT_BETWEEN', ], ], 'ConditionOverrides' => [ 'type' => 'structure', 'members' => [ 'Range' => [ 'shape' => 'RangeOverride', ], ], 'sensitive' => true, ], 'Conditions' => [ 'type' => 'structure', 'members' => [ 'Range' => [ 'shape' => 'Range', ], 'ObjectCount' => [ 'shape' => 'ObjectCount', ], 'Threshold' => [ 'shape' => 'Threshold', ], ], 'sensitive' => true, ], 'ConflictResolution' => [ 'type' => 'structure', 'required' => [ 'ConflictResolvingModel', ], 'members' => [ 'ConflictResolvingModel' => [ 'shape' => 'ConflictResolvingModel', ], 'SourceName' => [ 'shape' => 'string1To255', ], ], ], 'ConflictResolvingModel' => [ 'type' => 'string', 'enum' => [ 'RECENCY', 'SOURCE', ], ], 'ConnectorOperator' => [ 'type' => 'structure', 'members' => [ 'Marketo' => [ 'shape' => 'MarketoConnectorOperator', ], 'S3' => [ 'shape' => 'S3ConnectorOperator', ], 'Salesforce' => [ 'shape' => 'SalesforceConnectorOperator', ], 'ServiceNow' => [ 'shape' => 'ServiceNowConnectorOperator', ], 'Zendesk' => [ 'shape' => 'ZendeskConnectorOperator', ], ], ], 'ConnectorProfileName' => [ 'type' => 'string', 'max' => 256, 'pattern' => '[\\w/!@#+=.-]+', ], 'Consolidation' => [ 'type' => 'structure', 'required' => [ 'MatchingAttributesList', ], 'members' => [ 'MatchingAttributesList' => [ 'shape' => 'MatchingAttributesList', ], ], ], 'ContactPreference' => [ 'type' => 'structure', 'members' => [ 'KeyName' => [ 'shape' => 'name', ], 'KeyValue' => [ 'shape' => 'string1To255', ], 'ProfileId' => [ 'shape' => 'uuid', ], 'ContactType' => [ 'shape' => 'ContactType', ], ], ], 'ContactType' => [ 'type' => 'string', 'enum' => [ 'PhoneNumber', 'MobilePhoneNumber', 'HomePhoneNumber', 'BusinessPhoneNumber', 'EmailAddress', 'PersonalEmailAddress', 'BusinessEmailAddress', ], ], 'CreateCalculatedAttributeDefinitionRequest' => [ 'type' => 'structure', 'required' => [ 'DomainName', 'CalculatedAttributeName', 'AttributeDetails', 'Statistic', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], 'CalculatedAttributeName' => [ 'shape' => 'typeName', 'location' => 'uri', 'locationName' => 'CalculatedAttributeName', ], 'DisplayName' => [ 'shape' => 'displayName', ], 'Description' => [ 'shape' => 'sensitiveText', ], 'AttributeDetails' => [ 'shape' => 'AttributeDetails', ], 'Conditions' => [ 'shape' => 'Conditions', ], 'Filter' => [ 'shape' => 'Filter', ], 'Statistic' => [ 'shape' => 'Statistic', ], 'UseHistoricalData' => [ 'shape' => 'optionalBoolean', ], 'Tags' => [ 'shape' => 'TagMap', ], ], ], 'CreateCalculatedAttributeDefinitionResponse' => [ 'type' => 'structure', 'members' => [ 'CalculatedAttributeName' => [ 'shape' => 'typeName', ], 'DisplayName' => [ 'shape' => 'displayName', ], 'Description' => [ 'shape' => 'sensitiveText', ], 'AttributeDetails' => [ 'shape' => 'AttributeDetails', ], 'Conditions' => [ 'shape' => 'Conditions', ], 'Filter' => [ 'shape' => 'Filter', ], 'Statistic' => [ 'shape' => 'Statistic', ], 'CreatedAt' => [ 'shape' => 'timestamp', ], 'LastUpdatedAt' => [ 'shape' => 'timestamp', ], 'UseHistoricalData' => [ 'shape' => 'optionalBoolean', ], 'Status' => [ 'shape' => 'ReadinessStatus', ], 'Readiness' => [ 'shape' => 'Readiness', ], 'Tags' => [ 'shape' => 'TagMap', ], ], ], 'CreateDomainLayoutRequest' => [ 'type' => 'structure', 'required' => [ 'DomainName', 'LayoutDefinitionName', 'Description', 'DisplayName', 'LayoutType', 'Layout', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], 'LayoutDefinitionName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'LayoutDefinitionName', ], 'Description' => [ 'shape' => 'sensitiveText', ], 'DisplayName' => [ 'shape' => 'displayName', ], 'IsDefault' => [ 'shape' => 'boolean', ], 'LayoutType' => [ 'shape' => 'LayoutType', ], 'Layout' => [ 'shape' => 'sensitiveString1To2000000', ], 'Tags' => [ 'shape' => 'TagMap', ], ], ], 'CreateDomainLayoutResponse' => [ 'type' => 'structure', 'required' => [ 'LayoutDefinitionName', 'Description', 'DisplayName', 'LayoutType', 'Layout', 'Version', 'CreatedAt', ], 'members' => [ 'LayoutDefinitionName' => [ 'shape' => 'name', ], 'Description' => [ 'shape' => 'sensitiveText', ], 'DisplayName' => [ 'shape' => 'displayName', ], 'IsDefault' => [ 'shape' => 'boolean', ], 'LayoutType' => [ 'shape' => 'LayoutType', ], 'Layout' => [ 'shape' => 'sensitiveString1To2000000', ], 'Version' => [ 'shape' => 'string1To255', ], 'Tags' => [ 'shape' => 'TagMap', ], 'CreatedAt' => [ 'shape' => 'timestamp', ], 'LastUpdatedAt' => [ 'shape' => 'timestamp', ], ], ], 'CreateDomainRequest' => [ 'type' => 'structure', 'required' => [ 'DomainName', 'DefaultExpirationDays', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], 'DefaultExpirationDays' => [ 'shape' => 'expirationDaysInteger', ], 'DefaultEncryptionKey' => [ 'shape' => 'encryptionKey', ], 'DeadLetterQueueUrl' => [ 'shape' => 'sqsQueueUrl', ], 'Matching' => [ 'shape' => 'MatchingRequest', ], 'RuleBasedMatching' => [ 'shape' => 'RuleBasedMatchingRequest', ], 'Tags' => [ 'shape' => 'TagMap', ], ], ], 'CreateDomainResponse' => [ 'type' => 'structure', 'required' => [ 'DomainName', 'DefaultExpirationDays', 'CreatedAt', 'LastUpdatedAt', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', ], 'DefaultExpirationDays' => [ 'shape' => 'expirationDaysInteger', ], 'DefaultEncryptionKey' => [ 'shape' => 'encryptionKey', ], 'DeadLetterQueueUrl' => [ 'shape' => 'sqsQueueUrl', ], 'Matching' => [ 'shape' => 'MatchingResponse', ], 'RuleBasedMatching' => [ 'shape' => 'RuleBasedMatchingResponse', ], 'CreatedAt' => [ 'shape' => 'timestamp', ], 'LastUpdatedAt' => [ 'shape' => 'timestamp', ], 'Tags' => [ 'shape' => 'TagMap', ], ], ], 'CreateEventStreamRequest' => [ 'type' => 'structure', 'required' => [ 'DomainName', 'Uri', 'EventStreamName', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], 'Uri' => [ 'shape' => 'string1To255', ], 'EventStreamName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'EventStreamName', ], 'Tags' => [ 'shape' => 'TagMap', ], ], ], 'CreateEventStreamResponse' => [ 'type' => 'structure', 'required' => [ 'EventStreamArn', ], 'members' => [ 'EventStreamArn' => [ 'shape' => 'string1To255', ], 'Tags' => [ 'shape' => 'TagMap', ], ], ], 'CreateEventTriggerRequest' => [ 'type' => 'structure', 'required' => [ 'DomainName', 'EventTriggerName', 'ObjectTypeName', 'EventTriggerConditions', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], 'EventTriggerName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'EventTriggerName', ], 'ObjectTypeName' => [ 'shape' => 'typeName', ], 'Description' => [ 'shape' => 'sensitiveText', ], 'EventTriggerConditions' => [ 'shape' => 'EventTriggerConditions', ], 'SegmentFilter' => [ 'shape' => 'name', ], 'EventTriggerLimits' => [ 'shape' => 'EventTriggerLimits', ], 'Tags' => [ 'shape' => 'TagMap', ], ], ], 'CreateEventTriggerResponse' => [ 'type' => 'structure', 'members' => [ 'EventTriggerName' => [ 'shape' => 'name', ], 'ObjectTypeName' => [ 'shape' => 'typeName', ], 'Description' => [ 'shape' => 'sensitiveText', ], 'EventTriggerConditions' => [ 'shape' => 'EventTriggerConditions', ], 'SegmentFilter' => [ 'shape' => 'name', ], 'EventTriggerLimits' => [ 'shape' => 'EventTriggerLimits', ], 'CreatedAt' => [ 'shape' => 'timestamp', ], 'LastUpdatedAt' => [ 'shape' => 'timestamp', ], 'Tags' => [ 'shape' => 'TagMap', ], ], ], 'CreateIntegrationWorkflowRequest' => [ 'type' => 'structure', 'required' => [ 'DomainName', 'WorkflowType', 'IntegrationConfig', 'ObjectTypeName', 'RoleArn', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], 'WorkflowType' => [ 'shape' => 'WorkflowType', ], 'IntegrationConfig' => [ 'shape' => 'IntegrationConfig', ], 'ObjectTypeName' => [ 'shape' => 'typeName', ], 'RoleArn' => [ 'shape' => 'RoleArn', ], 'Tags' => [ 'shape' => 'TagMap', ], ], ], 'CreateIntegrationWorkflowResponse' => [ 'type' => 'structure', 'required' => [ 'WorkflowId', 'Message', ], 'members' => [ 'WorkflowId' => [ 'shape' => 'uuid', ], 'Message' => [ 'shape' => 'string1To255', ], ], ], 'CreateProfileRequest' => [ 'type' => 'structure', 'required' => [ 'DomainName', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], 'AccountNumber' => [ 'shape' => 'sensitiveString1To255', ], 'AdditionalInformation' => [ 'shape' => 'sensitiveString1To1000', ], 'PartyType' => [ 'shape' => 'PartyType', ], 'BusinessName' => [ 'shape' => 'sensitiveString1To255', ], 'FirstName' => [ 'shape' => 'sensitiveString1To255', ], 'MiddleName' => [ 'shape' => 'sensitiveString1To255', ], 'LastName' => [ 'shape' => 'sensitiveString1To255', ], 'BirthDate' => [ 'shape' => 'sensitiveString1To255', ], 'Gender' => [ 'shape' => 'Gender', ], 'PhoneNumber' => [ 'shape' => 'sensitiveString1To255', ], 'MobilePhoneNumber' => [ 'shape' => 'sensitiveString1To255', ], 'HomePhoneNumber' => [ 'shape' => 'sensitiveString1To255', ], 'BusinessPhoneNumber' => [ 'shape' => 'sensitiveString1To255', ], 'EmailAddress' => [ 'shape' => 'sensitiveString1To255', ], 'PersonalEmailAddress' => [ 'shape' => 'sensitiveString1To255', ], 'BusinessEmailAddress' => [ 'shape' => 'sensitiveString1To255', ], 'Address' => [ 'shape' => 'Address', ], 'ShippingAddress' => [ 'shape' => 'Address', ], 'MailingAddress' => [ 'shape' => 'Address', ], 'BillingAddress' => [ 'shape' => 'Address', ], 'Attributes' => [ 'shape' => 'Attributes', ], 'PartyTypeString' => [ 'shape' => 'sensitiveString1To255', ], 'GenderString' => [ 'shape' => 'sensitiveString1To255', ], 'ProfileType' => [ 'shape' => 'ProfileType', ], 'EngagementPreferences' => [ 'shape' => 'EngagementPreferences', ], ], ], 'CreateProfileResponse' => [ 'type' => 'structure', 'required' => [ 'ProfileId', ], 'members' => [ 'ProfileId' => [ 'shape' => 'uuid', ], ], ], 'CreateSegmentDefinitionRequest' => [ 'type' => 'structure', 'required' => [ 'DomainName', 'SegmentDefinitionName', 'DisplayName', 'SegmentGroups', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], 'SegmentDefinitionName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'SegmentDefinitionName', ], 'DisplayName' => [ 'shape' => 'string1To255', ], 'Description' => [ 'shape' => 'sensitiveText', ], 'SegmentGroups' => [ 'shape' => 'SegmentGroup', ], 'Tags' => [ 'shape' => 'TagMap', ], ], ], 'CreateSegmentDefinitionResponse' => [ 'type' => 'structure', 'required' => [ 'SegmentDefinitionName', ], 'members' => [ 'SegmentDefinitionName' => [ 'shape' => 'name', 'locationName' => 'SegmentDefinitionName', ], 'DisplayName' => [ 'shape' => 'string1To255', 'locationName' => 'DisplayName', ], 'Description' => [ 'shape' => 'sensitiveText', 'locationName' => 'Description', ], 'CreatedAt' => [ 'shape' => 'timestamp', 'locationName' => 'CreatedAt', ], 'SegmentDefinitionArn' => [ 'shape' => 'SegmentDefinitionArn', 'locationName' => 'SegmentDefinitionArn', ], 'Tags' => [ 'shape' => 'TagMap', 'locationName' => 'Tags', ], ], ], 'CreateSegmentEstimateRequest' => [ 'type' => 'structure', 'required' => [ 'DomainName', 'SegmentQuery', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], 'SegmentQuery' => [ 'shape' => 'SegmentGroupStructure', ], ], ], 'CreateSegmentEstimateResponse' => [ 'type' => 'structure', 'members' => [ 'DomainName' => [ 'shape' => 'name', ], 'EstimateId' => [ 'shape' => 'string1To255', ], 'StatusCode' => [ 'shape' => 'StatusCode', 'location' => 'statusCode', ], ], ], 'CreateSegmentSnapshotRequest' => [ 'type' => 'structure', 'required' => [ 'DomainName', 'SegmentDefinitionName', 'DataFormat', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], 'SegmentDefinitionName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'SegmentDefinitionName', ], 'DataFormat' => [ 'shape' => 'DataFormat', ], 'EncryptionKey' => [ 'shape' => 'encryptionKey', ], 'RoleArn' => [ 'shape' => 'RoleArn', ], 'DestinationUri' => [ 'shape' => 'string1To255', ], ], ], 'CreateSegmentSnapshotResponse' => [ 'type' => 'structure', 'required' => [ 'SnapshotId', ], 'members' => [ 'SnapshotId' => [ 'shape' => 'uuid', ], ], ], 'CreateUploadJobRequest' => [ 'type' => 'structure', 'required' => [ 'DomainName', 'DisplayName', 'Fields', 'UniqueKey', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], 'DisplayName' => [ 'shape' => 'string1To255', ], 'Fields' => [ 'shape' => 'FieldMap', ], 'UniqueKey' => [ 'shape' => 'text', ], 'DataExpiry' => [ 'shape' => 'expirationDaysInteger', ], ], ], 'CreateUploadJobResponse' => [ 'type' => 'structure', 'required' => [ 'JobId', ], 'members' => [ 'JobId' => [ 'shape' => 'uuid', 'locationName' => 'JobId', ], ], ], 'CustomAttributes' => [ 'type' => 'map', 'key' => [ 'shape' => 'typeName', ], 'value' => [ 'shape' => 'AttributeDimension', ], ], 'DataFormat' => [ 'type' => 'string', 'enum' => [ 'CSV', 'JSONL', 'ORC', ], ], 'DataPullMode' => [ 'type' => 'string', 'enum' => [ 'Incremental', 'Complete', ], ], 'Date' => [ 'type' => 'timestamp', ], 'DateDimension' => [ 'type' => 'structure', 'required' => [ 'DimensionType', 'Values', ], 'members' => [ 'DimensionType' => [ 'shape' => 'DateDimensionType', 'locationName' => 'DimensionType', ], 'Values' => [ 'shape' => 'DateValues', 'locationName' => 'Values', ], ], ], 'DateDimensionType' => [ 'type' => 'string', 'enum' => [ 'BEFORE', 'AFTER', 'BETWEEN', 'NOT_BETWEEN', 'ON', ], ], 'DateValues' => [ 'type' => 'list', 'member' => [ 'shape' => 'String', ], 'max' => 50, 'min' => 1, ], 'DatetimeTypeFieldName' => [ 'type' => 'string', 'max' => 256, 'pattern' => '.*', ], 'DeleteCalculatedAttributeDefinitionRequest' => [ 'type' => 'structure', 'required' => [ 'DomainName', 'CalculatedAttributeName', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], 'CalculatedAttributeName' => [ 'shape' => 'typeName', 'location' => 'uri', 'locationName' => 'CalculatedAttributeName', ], ], ], 'DeleteCalculatedAttributeDefinitionResponse' => [ 'type' => 'structure', 'members' => [], ], 'DeleteDomainLayoutRequest' => [ 'type' => 'structure', 'required' => [ 'DomainName', 'LayoutDefinitionName', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], 'LayoutDefinitionName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'LayoutDefinitionName', ], ], ], 'DeleteDomainLayoutResponse' => [ 'type' => 'structure', 'required' => [ 'Message', ], 'members' => [ 'Message' => [ 'shape' => 'message', ], ], ], 'DeleteDomainRequest' => [ 'type' => 'structure', 'required' => [ 'DomainName', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], ], ], 'DeleteDomainResponse' => [ 'type' => 'structure', 'required' => [ 'Message', ], 'members' => [ 'Message' => [ 'shape' => 'message', ], ], ], 'DeleteEventStreamRequest' => [ 'type' => 'structure', 'required' => [ 'DomainName', 'EventStreamName', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], 'EventStreamName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'EventStreamName', ], ], ], 'DeleteEventStreamResponse' => [ 'type' => 'structure', 'members' => [], ], 'DeleteEventTriggerRequest' => [ 'type' => 'structure', 'required' => [ 'DomainName', 'EventTriggerName', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], 'EventTriggerName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'EventTriggerName', ], ], ], 'DeleteEventTriggerResponse' => [ 'type' => 'structure', 'required' => [ 'Message', ], 'members' => [ 'Message' => [ 'shape' => 'message', ], ], ], 'DeleteIntegrationRequest' => [ 'type' => 'structure', 'required' => [ 'DomainName', 'Uri', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], 'Uri' => [ 'shape' => 'string1To255', ], ], ], 'DeleteIntegrationResponse' => [ 'type' => 'structure', 'required' => [ 'Message', ], 'members' => [ 'Message' => [ 'shape' => 'message', ], ], ], 'DeleteProfileKeyRequest' => [ 'type' => 'structure', 'required' => [ 'ProfileId', 'KeyName', 'Values', 'DomainName', ], 'members' => [ 'ProfileId' => [ 'shape' => 'uuid', ], 'KeyName' => [ 'shape' => 'name', ], 'Values' => [ 'shape' => 'requestValueList', ], 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], ], ], 'DeleteProfileKeyResponse' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'message', ], ], ], 'DeleteProfileObjectRequest' => [ 'type' => 'structure', 'required' => [ 'ProfileId', 'ProfileObjectUniqueKey', 'ObjectTypeName', 'DomainName', ], 'members' => [ 'ProfileId' => [ 'shape' => 'uuid', ], 'ProfileObjectUniqueKey' => [ 'shape' => 'string1To255', ], 'ObjectTypeName' => [ 'shape' => 'typeName', ], 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], ], ], 'DeleteProfileObjectResponse' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'message', ], ], ], 'DeleteProfileObjectTypeRequest' => [ 'type' => 'structure', 'required' => [ 'DomainName', 'ObjectTypeName', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], 'ObjectTypeName' => [ 'shape' => 'typeName', 'location' => 'uri', 'locationName' => 'ObjectTypeName', ], ], ], 'DeleteProfileObjectTypeResponse' => [ 'type' => 'structure', 'required' => [ 'Message', ], 'members' => [ 'Message' => [ 'shape' => 'message', ], ], ], 'DeleteProfileRequest' => [ 'type' => 'structure', 'required' => [ 'ProfileId', 'DomainName', ], 'members' => [ 'ProfileId' => [ 'shape' => 'uuid', ], 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], ], ], 'DeleteProfileResponse' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'message', ], ], ], 'DeleteSegmentDefinitionRequest' => [ 'type' => 'structure', 'required' => [ 'DomainName', 'SegmentDefinitionName', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], 'SegmentDefinitionName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'SegmentDefinitionName', ], ], ], 'DeleteSegmentDefinitionResponse' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'string1To1000', 'locationName' => 'Message', ], ], ], 'DeleteWorkflowRequest' => [ 'type' => 'structure', 'required' => [ 'DomainName', 'WorkflowId', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], 'WorkflowId' => [ 'shape' => 'string1To255', 'location' => 'uri', 'locationName' => 'WorkflowId', ], ], ], 'DeleteWorkflowResponse' => [ 'type' => 'structure', 'members' => [], ], 'DestinationField' => [ 'type' => 'string', 'max' => 256, 'pattern' => '.*', ], 'DestinationSummary' => [ 'type' => 'structure', 'required' => [ 'Uri', 'Status', ], 'members' => [ 'Uri' => [ 'shape' => 'string1To255', ], 'Status' => [ 'shape' => 'EventStreamDestinationStatus', ], 'UnhealthySince' => [ 'shape' => 'timestamp', ], ], ], 'DetectProfileObjectTypeRequest' => [ 'type' => 'structure', 'required' => [ 'Objects', 'DomainName', ], 'members' => [ 'Objects' => [ 'shape' => 'Objects', ], 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], ], ], 'DetectProfileObjectTypeResponse' => [ 'type' => 'structure', 'members' => [ 'DetectedProfileObjectTypes' => [ 'shape' => 'DetectedProfileObjectTypes', ], ], ], 'DetectedProfileObjectType' => [ 'type' => 'structure', 'members' => [ 'SourceLastUpdatedTimestampFormat' => [ 'shape' => 'string1To255', ], 'Fields' => [ 'shape' => 'FieldMap', ], 'Keys' => [ 'shape' => 'KeyMap', ], ], ], 'DetectedProfileObjectTypes' => [ 'type' => 'list', 'member' => [ 'shape' => 'DetectedProfileObjectType', ], ], 'Dimension' => [ 'type' => 'structure', 'members' => [ 'ProfileAttributes' => [ 'shape' => 'ProfileAttributes', 'locationName' => 'ProfileAttributes', ], 'CalculatedAttributes' => [ 'shape' => 'CalculatedCustomAttributes', 'locationName' => 'CalculatedAttributes', ], ], 'union' => true, ], 'DimensionList' => [ 'type' => 'list', 'member' => [ 'shape' => 'Dimension', ], ], 'DomainList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ListDomainItem', ], ], 'DomainStats' => [ 'type' => 'structure', 'members' => [ 'ProfileCount' => [ 'shape' => 'long', ], 'MeteringProfileCount' => [ 'shape' => 'long', ], 'ObjectCount' => [ 'shape' => 'long', ], 'TotalSize' => [ 'shape' => 'long', ], ], ], 'Double' => [ 'type' => 'double', ], 'Double0To1' => [ 'type' => 'double', 'max' => 1.0, 'min' => 0.0, ], 'EmailList' => [ 'type' => 'list', 'member' => [ 'shape' => 'string1To255', ], 'max' => 3, 'min' => 1, ], 'EmailPreferenceList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ContactPreference', ], ], 'End' => [ 'type' => 'integer', ], 'EngagementPreferences' => [ 'type' => 'structure', 'members' => [ 'Phone' => [ 'shape' => 'PhonePreferenceList', ], 'Email' => [ 'shape' => 'EmailPreferenceList', ], ], 'sensitive' => true, ], 'EstimateStatus' => [ 'type' => 'string', 'enum' => [ 'RUNNING', 'SUCCEEDED', 'FAILED', ], ], 'EventStreamDestinationDetails' => [ 'type' => 'structure', 'required' => [ 'Uri', 'Status', ], 'members' => [ 'Uri' => [ 'shape' => 'string1To255', ], 'Status' => [ 'shape' => 'EventStreamDestinationStatus', ], 'UnhealthySince' => [ 'shape' => 'timestamp', ], 'Message' => [ 'shape' => 'string1To1000', ], ], ], 'EventStreamDestinationStatus' => [ 'type' => 'string', 'enum' => [ 'HEALTHY', 'UNHEALTHY', ], ], 'EventStreamState' => [ 'type' => 'string', 'enum' => [ 'RUNNING', 'STOPPED', ], ], 'EventStreamSummary' => [ 'type' => 'structure', 'required' => [ 'DomainName', 'EventStreamName', 'EventStreamArn', 'State', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', ], 'EventStreamName' => [ 'shape' => 'name', ], 'EventStreamArn' => [ 'shape' => 'string1To255', ], 'State' => [ 'shape' => 'EventStreamState', ], 'StoppedSince' => [ 'shape' => 'timestamp', ], 'DestinationSummary' => [ 'shape' => 'DestinationSummary', ], 'Tags' => [ 'shape' => 'TagMap', ], ], ], 'EventStreamSummaryList' => [ 'type' => 'list', 'member' => [ 'shape' => 'EventStreamSummary', ], ], 'EventTriggerCondition' => [ 'type' => 'structure', 'required' => [ 'EventTriggerDimensions', 'LogicalOperator', ], 'members' => [ 'EventTriggerDimensions' => [ 'shape' => 'EventTriggerDimensions', ], 'LogicalOperator' => [ 'shape' => 'EventTriggerLogicalOperator', ], ], ], 'EventTriggerConditions' => [ 'type' => 'list', 'member' => [ 'shape' => 'EventTriggerCondition', ], 'max' => 5, 'min' => 1, 'sensitive' => true, ], 'EventTriggerDimension' => [ 'type' => 'structure', 'required' => [ 'ObjectAttributes', ], 'members' => [ 'ObjectAttributes' => [ 'shape' => 'ObjectAttributes', ], ], ], 'EventTriggerDimensions' => [ 'type' => 'list', 'member' => [ 'shape' => 'EventTriggerDimension', ], 'max' => 10, 'min' => 1, ], 'EventTriggerLimits' => [ 'type' => 'structure', 'members' => [ 'EventExpiration' => [ 'shape' => 'optionalLong', ], 'Periods' => [ 'shape' => 'Periods', ], ], ], 'EventTriggerLogicalOperator' => [ 'type' => 'string', 'enum' => [ 'ANY', 'ALL', 'NONE', ], ], 'EventTriggerNames' => [ 'type' => 'list', 'member' => [ 'shape' => 'name', ], 'max' => 1, 'min' => 1, ], 'EventTriggerSummaryItem' => [ 'type' => 'structure', 'members' => [ 'ObjectTypeName' => [ 'shape' => 'typeName', ], 'EventTriggerName' => [ 'shape' => 'name', ], 'Description' => [ 'shape' => 'text', ], 'CreatedAt' => [ 'shape' => 'timestamp', ], 'LastUpdatedAt' => [ 'shape' => 'timestamp', ], 'Tags' => [ 'shape' => 'TagMap', ], ], ], 'EventTriggerSummaryList' => [ 'type' => 'list', 'member' => [ 'shape' => 'EventTriggerSummaryItem', ], 'sensitive' => true, ], 'EventTriggerValues' => [ 'type' => 'list', 'member' => [ 'shape' => 'string1To255', ], 'max' => 10, 'min' => 1, ], 'ExportingConfig' => [ 'type' => 'structure', 'members' => [ 'S3Exporting' => [ 'shape' => 'S3ExportingConfig', ], ], ], 'ExportingLocation' => [ 'type' => 'structure', 'members' => [ 'S3Exporting' => [ 'shape' => 'S3ExportingLocation', ], ], ], 'ExtraLengthValueProfileDimension' => [ 'type' => 'structure', 'required' => [ 'DimensionType', 'Values', ], 'members' => [ 'DimensionType' => [ 'shape' => 'StringDimensionType', 'locationName' => 'DimensionType', ], 'Values' => [ 'shape' => 'ExtraLengthValues', 'locationName' => 'Values', ], ], ], 'ExtraLengthValues' => [ 'type' => 'list', 'member' => [ 'shape' => 'string1To1000', ], 'max' => 50, 'min' => 1, ], 'Failures' => [ 'type' => 'list', 'member' => [ 'shape' => 'ProfileQueryFailures', ], ], 'FieldContentType' => [ 'type' => 'string', 'enum' => [ 'STRING', 'NUMBER', 'PHONE_NUMBER', 'EMAIL_ADDRESS', 'NAME', ], ], 'FieldMap' => [ 'type' => 'map', 'key' => [ 'shape' => 'fieldName', ], 'value' => [ 'shape' => 'ObjectTypeField', ], 'sensitive' => true, ], 'FieldNameList' => [ 'type' => 'list', 'member' => [ 'shape' => 'name', ], ], 'FieldSourceProfileIds' => [ 'type' => 'structure', 'members' => [ 'AccountNumber' => [ 'shape' => 'uuid', ], 'AdditionalInformation' => [ 'shape' => 'uuid', ], 'PartyType' => [ 'shape' => 'uuid', ], 'BusinessName' => [ 'shape' => 'uuid', ], 'FirstName' => [ 'shape' => 'uuid', ], 'MiddleName' => [ 'shape' => 'uuid', ], 'LastName' => [ 'shape' => 'uuid', ], 'BirthDate' => [ 'shape' => 'uuid', ], 'Gender' => [ 'shape' => 'uuid', ], 'PhoneNumber' => [ 'shape' => 'uuid', ], 'MobilePhoneNumber' => [ 'shape' => 'uuid', ], 'HomePhoneNumber' => [ 'shape' => 'uuid', ], 'BusinessPhoneNumber' => [ 'shape' => 'uuid', ], 'EmailAddress' => [ 'shape' => 'uuid', ], 'PersonalEmailAddress' => [ 'shape' => 'uuid', ], 'BusinessEmailAddress' => [ 'shape' => 'uuid', ], 'Address' => [ 'shape' => 'uuid', ], 'ShippingAddress' => [ 'shape' => 'uuid', ], 'MailingAddress' => [ 'shape' => 'uuid', ], 'BillingAddress' => [ 'shape' => 'uuid', ], 'Attributes' => [ 'shape' => 'AttributeSourceIdMap', ], 'ProfileType' => [ 'shape' => 'uuid', ], 'EngagementPreferences' => [ 'shape' => 'uuid', ], ], ], 'Filter' => [ 'type' => 'structure', 'required' => [ 'Include', 'Groups', ], 'members' => [ 'Include' => [ 'shape' => 'Include', ], 'Groups' => [ 'shape' => 'GroupList', ], ], ], 'FilterAttributeDimension' => [ 'type' => 'structure', 'required' => [ 'DimensionType', 'Values', ], 'members' => [ 'DimensionType' => [ 'shape' => 'FilterDimensionType', ], 'Values' => [ 'shape' => 'ValueList', ], ], ], 'FilterDimension' => [ 'type' => 'structure', 'required' => [ 'Attributes', ], 'members' => [ 'Attributes' => [ 'shape' => 'AttributeMap', ], ], ], 'FilterDimensionList' => [ 'type' => 'list', 'member' => [ 'shape' => 'FilterDimension', ], 'max' => 10, 'min' => 1, ], 'FilterDimensionType' => [ 'type' => 'string', 'enum' => [ 'INCLUSIVE', 'EXCLUSIVE', 'CONTAINS', 'BEGINS_WITH', 'ENDS_WITH', 'BEFORE', 'AFTER', 'BETWEEN', 'NOT_BETWEEN', 'ON', 'GREATER_THAN', 'LESS_THAN', 'GREATER_THAN_OR_EQUAL', 'LESS_THAN_OR_EQUAL', 'EQUAL', ], ], 'FilterGroup' => [ 'type' => 'structure', 'required' => [ 'Type', 'Dimensions', ], 'members' => [ 'Type' => [ 'shape' => 'Type', ], 'Dimensions' => [ 'shape' => 'FilterDimensionList', ], ], ], 'FlowDefinition' => [ 'type' => 'structure', 'required' => [ 'FlowName', 'KmsArn', 'SourceFlowConfig', 'Tasks', 'TriggerConfig', ], 'members' => [ 'Description' => [ 'shape' => 'FlowDescription', ], 'FlowName' => [ 'shape' => 'FlowName', ], 'KmsArn' => [ 'shape' => 'KmsArn', ], 'SourceFlowConfig' => [ 'shape' => 'SourceFlowConfig', ], 'Tasks' => [ 'shape' => 'Tasks', ], 'TriggerConfig' => [ 'shape' => 'TriggerConfig', ], ], 'sensitive' => true, ], 'FlowDescription' => [ 'type' => 'string', 'max' => 2048, 'pattern' => '[\\w!@#\\-.?,\\s]*', ], 'FlowName' => [ 'type' => 'string', 'max' => 256, 'pattern' => '[a-zA-Z0-9][\\w!@#.-]+', ], 'FoundByKeyValue' => [ 'type' => 'structure', 'members' => [ 'KeyName' => [ 'shape' => 'name', ], 'Values' => [ 'shape' => 'requestValueList', ], ], ], 'Gender' => [ 'type' => 'string', 'deprecated' => true, 'enum' => [ 'MALE', 'FEMALE', 'UNSPECIFIED', ], 'sensitive' => true, ], 'GetAutoMergingPreviewRequest' => [ 'type' => 'structure', 'required' => [ 'DomainName', 'Consolidation', 'ConflictResolution', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], 'Consolidation' => [ 'shape' => 'Consolidation', ], 'ConflictResolution' => [ 'shape' => 'ConflictResolution', ], 'MinAllowedConfidenceScoreForMerging' => [ 'shape' => 'Double0To1', ], ], ], 'GetAutoMergingPreviewResponse' => [ 'type' => 'structure', 'required' => [ 'DomainName', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', ], 'NumberOfMatchesInSample' => [ 'shape' => 'long', ], 'NumberOfProfilesInSample' => [ 'shape' => 'long', ], 'NumberOfProfilesWillBeMerged' => [ 'shape' => 'long', ], ], ], 'GetCalculatedAttributeDefinitionRequest' => [ 'type' => 'structure', 'required' => [ 'DomainName', 'CalculatedAttributeName', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], 'CalculatedAttributeName' => [ 'shape' => 'typeName', 'location' => 'uri', 'locationName' => 'CalculatedAttributeName', ], ], ], 'GetCalculatedAttributeDefinitionResponse' => [ 'type' => 'structure', 'members' => [ 'CalculatedAttributeName' => [ 'shape' => 'typeName', ], 'DisplayName' => [ 'shape' => 'displayName', ], 'Description' => [ 'shape' => 'sensitiveText', ], 'CreatedAt' => [ 'shape' => 'timestamp', ], 'LastUpdatedAt' => [ 'shape' => 'timestamp', ], 'Statistic' => [ 'shape' => 'Statistic', ], 'Filter' => [ 'shape' => 'Filter', ], 'Conditions' => [ 'shape' => 'Conditions', ], 'AttributeDetails' => [ 'shape' => 'AttributeDetails', ], 'UseHistoricalData' => [ 'shape' => 'optionalBoolean', ], 'Status' => [ 'shape' => 'ReadinessStatus', ], 'Readiness' => [ 'shape' => 'Readiness', ], 'Tags' => [ 'shape' => 'TagMap', ], ], ], 'GetCalculatedAttributeForProfileRequest' => [ 'type' => 'structure', 'required' => [ 'DomainName', 'ProfileId', 'CalculatedAttributeName', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], 'ProfileId' => [ 'shape' => 'uuid', 'location' => 'uri', 'locationName' => 'ProfileId', ], 'CalculatedAttributeName' => [ 'shape' => 'typeName', 'location' => 'uri', 'locationName' => 'CalculatedAttributeName', ], ], ], 'GetCalculatedAttributeForProfileResponse' => [ 'type' => 'structure', 'members' => [ 'CalculatedAttributeName' => [ 'shape' => 'typeName', ], 'DisplayName' => [ 'shape' => 'displayName', ], 'IsDataPartial' => [ 'shape' => 'string1To255', ], 'Value' => [ 'shape' => 'string1To255', ], 'LastObjectTimestamp' => [ 'shape' => 'timestamp', ], ], ], 'GetDomainLayoutRequest' => [ 'type' => 'structure', 'required' => [ 'DomainName', 'LayoutDefinitionName', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], 'LayoutDefinitionName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'LayoutDefinitionName', ], ], ], 'GetDomainLayoutResponse' => [ 'type' => 'structure', 'required' => [ 'LayoutDefinitionName', 'Description', 'DisplayName', 'LayoutType', 'Layout', 'Version', 'CreatedAt', 'LastUpdatedAt', ], 'members' => [ 'LayoutDefinitionName' => [ 'shape' => 'name', ], 'Description' => [ 'shape' => 'sensitiveText', ], 'DisplayName' => [ 'shape' => 'displayName', ], 'IsDefault' => [ 'shape' => 'boolean', ], 'LayoutType' => [ 'shape' => 'LayoutType', ], 'Layout' => [ 'shape' => 'sensitiveString1To2000000', ], 'Version' => [ 'shape' => 'string1To255', ], 'CreatedAt' => [ 'shape' => 'timestamp', ], 'LastUpdatedAt' => [ 'shape' => 'timestamp', ], 'Tags' => [ 'shape' => 'TagMap', ], ], ], 'GetDomainRequest' => [ 'type' => 'structure', 'required' => [ 'DomainName', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], ], ], 'GetDomainResponse' => [ 'type' => 'structure', 'required' => [ 'DomainName', 'CreatedAt', 'LastUpdatedAt', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', ], 'DefaultExpirationDays' => [ 'shape' => 'expirationDaysInteger', ], 'DefaultEncryptionKey' => [ 'shape' => 'encryptionKey', ], 'DeadLetterQueueUrl' => [ 'shape' => 'sqsQueueUrl', ], 'Stats' => [ 'shape' => 'DomainStats', ], 'Matching' => [ 'shape' => 'MatchingResponse', ], 'RuleBasedMatching' => [ 'shape' => 'RuleBasedMatchingResponse', ], 'CreatedAt' => [ 'shape' => 'timestamp', ], 'LastUpdatedAt' => [ 'shape' => 'timestamp', ], 'Tags' => [ 'shape' => 'TagMap', ], ], ], 'GetEventStreamRequest' => [ 'type' => 'structure', 'required' => [ 'DomainName', 'EventStreamName', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], 'EventStreamName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'EventStreamName', ], ], ], 'GetEventStreamResponse' => [ 'type' => 'structure', 'required' => [ 'DomainName', 'EventStreamArn', 'CreatedAt', 'State', 'DestinationDetails', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', ], 'EventStreamArn' => [ 'shape' => 'string1To255', ], 'CreatedAt' => [ 'shape' => 'timestamp', ], 'State' => [ 'shape' => 'EventStreamState', ], 'StoppedSince' => [ 'shape' => 'timestamp', ], 'DestinationDetails' => [ 'shape' => 'EventStreamDestinationDetails', ], 'Tags' => [ 'shape' => 'TagMap', ], ], ], 'GetEventTriggerRequest' => [ 'type' => 'structure', 'required' => [ 'DomainName', 'EventTriggerName', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], 'EventTriggerName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'EventTriggerName', ], ], ], 'GetEventTriggerResponse' => [ 'type' => 'structure', 'members' => [ 'EventTriggerName' => [ 'shape' => 'name', ], 'ObjectTypeName' => [ 'shape' => 'typeName', ], 'Description' => [ 'shape' => 'sensitiveText', ], 'EventTriggerConditions' => [ 'shape' => 'EventTriggerConditions', ], 'SegmentFilter' => [ 'shape' => 'name', ], 'EventTriggerLimits' => [ 'shape' => 'EventTriggerLimits', ], 'CreatedAt' => [ 'shape' => 'timestamp', ], 'LastUpdatedAt' => [ 'shape' => 'timestamp', ], 'Tags' => [ 'shape' => 'TagMap', ], ], ], 'GetIdentityResolutionJobRequest' => [ 'type' => 'structure', 'required' => [ 'DomainName', 'JobId', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], 'JobId' => [ 'shape' => 'uuid', 'location' => 'uri', 'locationName' => 'JobId', ], ], ], 'GetIdentityResolutionJobResponse' => [ 'type' => 'structure', 'members' => [ 'DomainName' => [ 'shape' => 'name', ], 'JobId' => [ 'shape' => 'uuid', ], 'Status' => [ 'shape' => 'IdentityResolutionJobStatus', ], 'Message' => [ 'shape' => 'stringTo2048', ], 'JobStartTime' => [ 'shape' => 'timestamp', ], 'JobEndTime' => [ 'shape' => 'timestamp', ], 'LastUpdatedAt' => [ 'shape' => 'timestamp', ], 'JobExpirationTime' => [ 'shape' => 'timestamp', ], 'AutoMerging' => [ 'shape' => 'AutoMerging', ], 'ExportingLocation' => [ 'shape' => 'ExportingLocation', ], 'JobStats' => [ 'shape' => 'JobStats', ], ], ], 'GetIntegrationRequest' => [ 'type' => 'structure', 'required' => [ 'DomainName', 'Uri', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], 'Uri' => [ 'shape' => 'string1To255', ], ], ], 'GetIntegrationResponse' => [ 'type' => 'structure', 'required' => [ 'DomainName', 'Uri', 'CreatedAt', 'LastUpdatedAt', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', ], 'Uri' => [ 'shape' => 'string1To255', ], 'ObjectTypeName' => [ 'shape' => 'typeName', ], 'CreatedAt' => [ 'shape' => 'timestamp', ], 'LastUpdatedAt' => [ 'shape' => 'timestamp', ], 'Tags' => [ 'shape' => 'TagMap', ], 'ObjectTypeNames' => [ 'shape' => 'ObjectTypeNames', ], 'WorkflowId' => [ 'shape' => 'string1To255', ], 'IsUnstructured' => [ 'shape' => 'optionalBoolean', ], 'RoleArn' => [ 'shape' => 'RoleArn', ], 'EventTriggerNames' => [ 'shape' => 'EventTriggerNames', ], ], ], 'GetMatchesRequest' => [ 'type' => 'structure', 'required' => [ 'DomainName', ], 'members' => [ 'NextToken' => [ 'shape' => 'token', 'location' => 'querystring', 'locationName' => 'next-token', ], 'MaxResults' => [ 'shape' => 'maxSize100', 'location' => 'querystring', 'locationName' => 'max-results', ], 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], ], ], 'GetMatchesResponse' => [ 'type' => 'structure', 'members' => [ 'NextToken' => [ 'shape' => 'token', ], 'MatchGenerationDate' => [ 'shape' => 'timestamp', ], 'PotentialMatches' => [ 'shape' => 'matchesNumber', ], 'Matches' => [ 'shape' => 'MatchesList', ], ], ], 'GetProfileHistoryRecordRequest' => [ 'type' => 'structure', 'required' => [ 'DomainName', 'ProfileId', 'Id', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], 'ProfileId' => [ 'shape' => 'uuid', 'location' => 'uri', 'locationName' => 'ProfileId', ], 'Id' => [ 'shape' => 'uuid', 'location' => 'uri', 'locationName' => 'Id', ], ], ], 'GetProfileHistoryRecordResponse' => [ 'type' => 'structure', 'required' => [ 'Id', 'ObjectTypeName', 'CreatedAt', 'ActionType', ], 'members' => [ 'Id' => [ 'shape' => 'uuid', ], 'ObjectTypeName' => [ 'shape' => 'typeName', ], 'CreatedAt' => [ 'shape' => 'timestamp', ], 'LastUpdatedAt' => [ 'shape' => 'timestamp', ], 'ActionType' => [ 'shape' => 'ActionType', ], 'ProfileObjectUniqueKey' => [ 'shape' => 'string1To255', ], 'Content' => [ 'shape' => 'stringifiedJson', ], 'PerformedBy' => [ 'shape' => 'string1To255', ], ], ], 'GetProfileObjectTypeRequest' => [ 'type' => 'structure', 'required' => [ 'DomainName', 'ObjectTypeName', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], 'ObjectTypeName' => [ 'shape' => 'typeName', 'location' => 'uri', 'locationName' => 'ObjectTypeName', ], ], ], 'GetProfileObjectTypeResponse' => [ 'type' => 'structure', 'required' => [ 'ObjectTypeName', 'Description', ], 'members' => [ 'ObjectTypeName' => [ 'shape' => 'typeName', ], 'Description' => [ 'shape' => 'sensitiveText', ], 'TemplateId' => [ 'shape' => 'name', ], 'ExpirationDays' => [ 'shape' => 'expirationDaysInteger', ], 'EncryptionKey' => [ 'shape' => 'encryptionKey', ], 'AllowProfileCreation' => [ 'shape' => 'boolean', ], 'SourceLastUpdatedTimestampFormat' => [ 'shape' => 'string1To255', ], 'MaxAvailableProfileObjectCount' => [ 'shape' => 'minSize0', ], 'MaxProfileObjectCount' => [ 'shape' => 'minSize1', ], 'Fields' => [ 'shape' => 'FieldMap', ], 'Keys' => [ 'shape' => 'KeyMap', ], 'CreatedAt' => [ 'shape' => 'timestamp', ], 'LastUpdatedAt' => [ 'shape' => 'timestamp', ], 'Tags' => [ 'shape' => 'TagMap', ], ], ], 'GetProfileObjectTypeTemplateRequest' => [ 'type' => 'structure', 'required' => [ 'TemplateId', ], 'members' => [ 'TemplateId' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'TemplateId', ], ], ], 'GetProfileObjectTypeTemplateResponse' => [ 'type' => 'structure', 'members' => [ 'TemplateId' => [ 'shape' => 'name', ], 'SourceName' => [ 'shape' => 'name', ], 'SourceObject' => [ 'shape' => 'name', ], 'AllowProfileCreation' => [ 'shape' => 'boolean', ], 'SourceLastUpdatedTimestampFormat' => [ 'shape' => 'string1To255', ], 'Fields' => [ 'shape' => 'FieldMap', ], 'Keys' => [ 'shape' => 'KeyMap', ], ], ], 'GetSegmentDefinitionRequest' => [ 'type' => 'structure', 'required' => [ 'DomainName', 'SegmentDefinitionName', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], 'SegmentDefinitionName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'SegmentDefinitionName', ], ], ], 'GetSegmentDefinitionResponse' => [ 'type' => 'structure', 'required' => [ 'SegmentDefinitionArn', ], 'members' => [ 'SegmentDefinitionName' => [ 'shape' => 'name', 'locationName' => 'SegmentDefinitionName', ], 'DisplayName' => [ 'shape' => 'string1To255', 'locationName' => 'DisplayName', ], 'Description' => [ 'shape' => 'sensitiveText', 'locationName' => 'Description', ], 'SegmentGroups' => [ 'shape' => 'SegmentGroup', 'locationName' => 'SegmentGroups', ], 'SegmentDefinitionArn' => [ 'shape' => 'SegmentDefinitionArn', 'locationName' => 'SegmentDefinitionArn', ], 'CreatedAt' => [ 'shape' => 'timestamp', 'locationName' => 'CreatedAt', ], 'Tags' => [ 'shape' => 'TagMap', 'locationName' => 'Tags', ], ], ], 'GetSegmentEstimateRequest' => [ 'type' => 'structure', 'required' => [ 'DomainName', 'EstimateId', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], 'EstimateId' => [ 'shape' => 'string1To255', 'location' => 'uri', 'locationName' => 'EstimateId', ], ], ], 'GetSegmentEstimateResponse' => [ 'type' => 'structure', 'members' => [ 'DomainName' => [ 'shape' => 'name', ], 'EstimateId' => [ 'shape' => 'string1To255', ], 'Status' => [ 'shape' => 'EstimateStatus', ], 'Estimate' => [ 'shape' => 'string1To255', ], 'Message' => [ 'shape' => 'string1To255', ], 'StatusCode' => [ 'shape' => 'StatusCode', 'location' => 'statusCode', ], ], ], 'GetSegmentMembershipMessage' => [ 'type' => 'string', ], 'GetSegmentMembershipRequest' => [ 'type' => 'structure', 'required' => [ 'DomainName', 'SegmentDefinitionName', 'ProfileIds', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], 'SegmentDefinitionName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'SegmentDefinitionName', ], 'ProfileIds' => [ 'shape' => 'ProfileIds', 'locationName' => 'ProfileIds', ], ], ], 'GetSegmentMembershipResponse' => [ 'type' => 'structure', 'members' => [ 'SegmentDefinitionName' => [ 'shape' => 'name', 'locationName' => 'SegmentDefinitionName', ], 'Profiles' => [ 'shape' => 'Profiles', 'locationName' => 'Profiles', ], 'Failures' => [ 'shape' => 'Failures', 'locationName' => 'Failures', ], ], ], 'GetSegmentMembershipStatus' => [ 'type' => 'integer', 'box' => true, ], 'GetSegmentSnapshotRequest' => [ 'type' => 'structure', 'required' => [ 'DomainName', 'SegmentDefinitionName', 'SnapshotId', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], 'SegmentDefinitionName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'SegmentDefinitionName', ], 'SnapshotId' => [ 'shape' => 'uuid', 'location' => 'uri', 'locationName' => 'SnapshotId', ], ], ], 'GetSegmentSnapshotResponse' => [ 'type' => 'structure', 'required' => [ 'SnapshotId', 'Status', 'DataFormat', ], 'members' => [ 'SnapshotId' => [ 'shape' => 'uuid', ], 'Status' => [ 'shape' => 'SegmentSnapshotStatus', ], 'StatusMessage' => [ 'shape' => 'string1To1000', ], 'DataFormat' => [ 'shape' => 'DataFormat', ], 'EncryptionKey' => [ 'shape' => 'encryptionKey', ], 'RoleArn' => [ 'shape' => 'RoleArn', ], 'DestinationUri' => [ 'shape' => 'string1To255', ], ], ], 'GetSimilarProfilesRequest' => [ 'type' => 'structure', 'required' => [ 'DomainName', 'MatchType', 'SearchKey', 'SearchValue', ], 'members' => [ 'NextToken' => [ 'shape' => 'token', 'location' => 'querystring', 'locationName' => 'next-token', ], 'MaxResults' => [ 'shape' => 'maxSize100', 'location' => 'querystring', 'locationName' => 'max-results', ], 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], 'MatchType' => [ 'shape' => 'MatchType', ], 'SearchKey' => [ 'shape' => 'string1To255', ], 'SearchValue' => [ 'shape' => 'string1To255', ], ], ], 'GetSimilarProfilesResponse' => [ 'type' => 'structure', 'members' => [ 'ProfileIds' => [ 'shape' => 'ProfileIdList', ], 'MatchId' => [ 'shape' => 'string1To255', ], 'MatchType' => [ 'shape' => 'MatchType', ], 'RuleLevel' => [ 'shape' => 'RuleLevel', ], 'ConfidenceScore' => [ 'shape' => 'Double', ], 'NextToken' => [ 'shape' => 'token', ], ], ], 'GetUploadJobPathRequest' => [ 'type' => 'structure', 'required' => [ 'DomainName', 'JobId', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], 'JobId' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'JobId', ], ], ], 'GetUploadJobPathResponse' => [ 'type' => 'structure', 'required' => [ 'Url', ], 'members' => [ 'Url' => [ 'shape' => 'stringTo2048', 'locationName' => 'Url', ], 'ClientToken' => [ 'shape' => 'text', 'locationName' => 'ClientToken', ], 'ValidUntil' => [ 'shape' => 'timestamp', 'locationName' => 'ValidUntil', ], ], ], 'GetUploadJobRequest' => [ 'type' => 'structure', 'required' => [ 'DomainName', 'JobId', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], 'JobId' => [ 'shape' => 'uuid', 'location' => 'uri', 'locationName' => 'JobId', ], ], ], 'GetUploadJobResponse' => [ 'type' => 'structure', 'members' => [ 'JobId' => [ 'shape' => 'uuid', 'locationName' => 'JobId', ], 'DisplayName' => [ 'shape' => 'string1To255', 'locationName' => 'DisplayName', ], 'Status' => [ 'shape' => 'UploadJobStatus', 'locationName' => 'Status', ], 'StatusReason' => [ 'shape' => 'StatusReason', 'locationName' => 'StatusReason', ], 'CreatedAt' => [ 'shape' => 'timestamp', 'locationName' => 'CreatedAt', ], 'CompletedAt' => [ 'shape' => 'timestamp', 'locationName' => 'CompletedAt', ], 'Fields' => [ 'shape' => 'FieldMap', 'locationName' => 'Fields', ], 'UniqueKey' => [ 'shape' => 'text', 'locationName' => 'UniqueKey', ], 'ResultsSummary' => [ 'shape' => 'ResultsSummary', 'locationName' => 'ResultsSummary', ], 'DataExpiry' => [ 'shape' => 'expirationDaysInteger', 'locationName' => 'DataExpiry', ], ], ], 'GetWorkflowRequest' => [ 'type' => 'structure', 'required' => [ 'DomainName', 'WorkflowId', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], 'WorkflowId' => [ 'shape' => 'uuid', 'location' => 'uri', 'locationName' => 'WorkflowId', ], ], ], 'GetWorkflowResponse' => [ 'type' => 'structure', 'members' => [ 'WorkflowId' => [ 'shape' => 'uuid', ], 'WorkflowType' => [ 'shape' => 'WorkflowType', ], 'Status' => [ 'shape' => 'Status', ], 'ErrorDescription' => [ 'shape' => 'string1To255', ], 'StartDate' => [ 'shape' => 'timestamp', ], 'LastUpdatedAt' => [ 'shape' => 'timestamp', ], 'Attributes' => [ 'shape' => 'WorkflowAttributes', ], 'Metrics' => [ 'shape' => 'WorkflowMetrics', ], ], ], 'GetWorkflowStepsRequest' => [ 'type' => 'structure', 'required' => [ 'DomainName', 'WorkflowId', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], 'WorkflowId' => [ 'shape' => 'uuid', 'location' => 'uri', 'locationName' => 'WorkflowId', ], 'NextToken' => [ 'shape' => 'token', 'location' => 'querystring', 'locationName' => 'next-token', ], 'MaxResults' => [ 'shape' => 'maxSize100', 'location' => 'querystring', 'locationName' => 'max-results', ], ], ], 'GetWorkflowStepsResponse' => [ 'type' => 'structure', 'members' => [ 'WorkflowId' => [ 'shape' => 'uuid', ], 'WorkflowType' => [ 'shape' => 'WorkflowType', ], 'Items' => [ 'shape' => 'WorkflowStepsList', ], 'NextToken' => [ 'shape' => 'token', ], ], ], 'Group' => [ 'type' => 'structure', 'members' => [ 'Dimensions' => [ 'shape' => 'DimensionList', 'locationName' => 'Dimensions', ], 'SourceSegments' => [ 'shape' => 'SourceSegmentList', 'locationName' => 'SourceSegments', ], 'SourceType' => [ 'shape' => 'IncludeOptions', 'locationName' => 'SourceType', ], 'Type' => [ 'shape' => 'IncludeOptions', 'locationName' => 'Type', ], ], ], 'GroupList' => [ 'type' => 'list', 'member' => [ 'shape' => 'FilterGroup', ], 'max' => 2, 'min' => 1, ], 'IdentityResolutionJob' => [ 'type' => 'structure', 'members' => [ 'DomainName' => [ 'shape' => 'name', ], 'JobId' => [ 'shape' => 'uuid', ], 'Status' => [ 'shape' => 'IdentityResolutionJobStatus', ], 'JobStartTime' => [ 'shape' => 'timestamp', ], 'JobEndTime' => [ 'shape' => 'timestamp', ], 'JobStats' => [ 'shape' => 'JobStats', ], 'ExportingLocation' => [ 'shape' => 'ExportingLocation', ], 'Message' => [ 'shape' => 'stringTo2048', ], ], ], 'IdentityResolutionJobStatus' => [ 'type' => 'string', 'enum' => [ 'PENDING', 'PREPROCESSING', 'FIND_MATCHING', 'MERGING', 'COMPLETED', 'PARTIAL_SUCCESS', 'FAILED', ], ], 'IdentityResolutionJobsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'IdentityResolutionJob', ], ], 'Include' => [ 'type' => 'string', 'enum' => [ 'ALL', 'ANY', 'NONE', ], ], 'IncludeOptions' => [ 'type' => 'string', 'enum' => [ 'ALL', 'ANY', 'NONE', ], ], 'IncrementalPullConfig' => [ 'type' => 'structure', 'members' => [ 'DatetimeTypeFieldName' => [ 'shape' => 'DatetimeTypeFieldName', ], ], ], 'IntegrationConfig' => [ 'type' => 'structure', 'members' => [ 'AppflowIntegration' => [ 'shape' => 'AppflowIntegration', ], ], ], 'IntegrationList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ListIntegrationItem', ], ], 'InternalServerException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'message', ], ], 'error' => [ 'httpStatusCode' => 500, ], 'exception' => true, 'fault' => true, ], 'JobSchedule' => [ 'type' => 'structure', 'required' => [ 'DayOfTheWeek', 'Time', ], 'members' => [ 'DayOfTheWeek' => [ 'shape' => 'JobScheduleDayOfTheWeek', ], 'Time' => [ 'shape' => 'JobScheduleTime', ], ], ], 'JobScheduleDayOfTheWeek' => [ 'type' => 'string', 'enum' => [ 'SUNDAY', 'MONDAY', 'TUESDAY', 'WEDNESDAY', 'THURSDAY', 'FRIDAY', 'SATURDAY', ], ], 'JobScheduleTime' => [ 'type' => 'string', 'max' => 5, 'min' => 3, 'pattern' => '^([0-9]|0[0-9]|1[0-9]|2[0-3]):[0-5][0-9]$', ], 'JobStats' => [ 'type' => 'structure', 'members' => [ 'NumberOfProfilesReviewed' => [ 'shape' => 'long', ], 'NumberOfMatchesFound' => [ 'shape' => 'long', ], 'NumberOfMergesDone' => [ 'shape' => 'long', ], ], ], 'KeyMap' => [ 'type' => 'map', 'key' => [ 'shape' => 'name', ], 'value' => [ 'shape' => 'ObjectTypeKeyList', ], 'sensitive' => true, ], 'KmsArn' => [ 'type' => 'string', 'max' => 2048, 'min' => 20, 'pattern' => 'arn:aws:kms:.*:[0-9]+:.*', ], 'LayoutItem' => [ 'type' => 'structure', 'required' => [ 'LayoutDefinitionName', 'Description', 'DisplayName', 'LayoutType', 'CreatedAt', 'LastUpdatedAt', ], 'members' => [ 'LayoutDefinitionName' => [ 'shape' => 'name', ], 'Description' => [ 'shape' => 'sensitiveText', ], 'DisplayName' => [ 'shape' => 'displayName', ], 'IsDefault' => [ 'shape' => 'boolean', ], 'LayoutType' => [ 'shape' => 'LayoutType', ], 'Tags' => [ 'shape' => 'TagMap', ], 'CreatedAt' => [ 'shape' => 'timestamp', ], 'LastUpdatedAt' => [ 'shape' => 'timestamp', ], ], ], 'LayoutList' => [ 'type' => 'list', 'member' => [ 'shape' => 'LayoutItem', ], ], 'LayoutType' => [ 'type' => 'string', 'enum' => [ 'PROFILE_EXPLORER', ], ], 'ListAccountIntegrationsRequest' => [ 'type' => 'structure', 'required' => [ 'Uri', ], 'members' => [ 'Uri' => [ 'shape' => 'string1To255', ], 'NextToken' => [ 'shape' => 'token', 'location' => 'querystring', 'locationName' => 'next-token', ], 'MaxResults' => [ 'shape' => 'maxSize100', 'location' => 'querystring', 'locationName' => 'max-results', ], 'IncludeHidden' => [ 'shape' => 'optionalBoolean', 'location' => 'querystring', 'locationName' => 'include-hidden', ], ], ], 'ListAccountIntegrationsResponse' => [ 'type' => 'structure', 'members' => [ 'Items' => [ 'shape' => 'IntegrationList', ], 'NextToken' => [ 'shape' => 'token', ], ], ], 'ListCalculatedAttributeDefinitionItem' => [ 'type' => 'structure', 'members' => [ 'CalculatedAttributeName' => [ 'shape' => 'typeName', ], 'DisplayName' => [ 'shape' => 'displayName', ], 'Description' => [ 'shape' => 'sensitiveText', ], 'CreatedAt' => [ 'shape' => 'timestamp', ], 'LastUpdatedAt' => [ 'shape' => 'timestamp', ], 'UseHistoricalData' => [ 'shape' => 'optionalBoolean', ], 'Status' => [ 'shape' => 'ReadinessStatus', ], 'Tags' => [ 'shape' => 'TagMap', ], ], ], 'ListCalculatedAttributeDefinitionsRequest' => [ 'type' => 'structure', 'required' => [ 'DomainName', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], 'NextToken' => [ 'shape' => 'token', 'location' => 'querystring', 'locationName' => 'next-token', ], 'MaxResults' => [ 'shape' => 'maxSize100', 'location' => 'querystring', 'locationName' => 'max-results', ], ], ], 'ListCalculatedAttributeDefinitionsResponse' => [ 'type' => 'structure', 'members' => [ 'Items' => [ 'shape' => 'CalculatedAttributeDefinitionsList', ], 'NextToken' => [ 'shape' => 'token', ], ], ], 'ListCalculatedAttributeForProfileItem' => [ 'type' => 'structure', 'members' => [ 'CalculatedAttributeName' => [ 'shape' => 'typeName', ], 'DisplayName' => [ 'shape' => 'displayName', ], 'IsDataPartial' => [ 'shape' => 'string1To255', ], 'Value' => [ 'shape' => 'string1To255', ], 'LastObjectTimestamp' => [ 'shape' => 'timestamp', ], ], ], 'ListCalculatedAttributesForProfileRequest' => [ 'type' => 'structure', 'required' => [ 'DomainName', 'ProfileId', ], 'members' => [ 'NextToken' => [ 'shape' => 'token', 'location' => 'querystring', 'locationName' => 'next-token', ], 'MaxResults' => [ 'shape' => 'maxSize100', 'location' => 'querystring', 'locationName' => 'max-results', ], 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], 'ProfileId' => [ 'shape' => 'uuid', 'location' => 'uri', 'locationName' => 'ProfileId', ], ], ], 'ListCalculatedAttributesForProfileResponse' => [ 'type' => 'structure', 'members' => [ 'Items' => [ 'shape' => 'CalculatedAttributesForProfileList', ], 'NextToken' => [ 'shape' => 'token', ], ], ], 'ListDomainItem' => [ 'type' => 'structure', 'required' => [ 'DomainName', 'CreatedAt', 'LastUpdatedAt', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', ], 'CreatedAt' => [ 'shape' => 'timestamp', ], 'LastUpdatedAt' => [ 'shape' => 'timestamp', ], 'Tags' => [ 'shape' => 'TagMap', ], ], ], 'ListDomainLayoutsRequest' => [ 'type' => 'structure', 'required' => [ 'DomainName', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], 'NextToken' => [ 'shape' => 'token', 'location' => 'querystring', 'locationName' => 'next-token', ], 'MaxResults' => [ 'shape' => 'maxSize100', 'location' => 'querystring', 'locationName' => 'max-results', ], ], ], 'ListDomainLayoutsResponse' => [ 'type' => 'structure', 'members' => [ 'Items' => [ 'shape' => 'LayoutList', ], 'NextToken' => [ 'shape' => 'token', ], ], ], 'ListDomainsRequest' => [ 'type' => 'structure', 'members' => [ 'NextToken' => [ 'shape' => 'token', 'location' => 'querystring', 'locationName' => 'next-token', ], 'MaxResults' => [ 'shape' => 'maxSize100', 'location' => 'querystring', 'locationName' => 'max-results', ], ], ], 'ListDomainsResponse' => [ 'type' => 'structure', 'members' => [ 'Items' => [ 'shape' => 'DomainList', ], 'NextToken' => [ 'shape' => 'token', ], ], ], 'ListEventStreamsRequest' => [ 'type' => 'structure', 'required' => [ 'DomainName', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], 'NextToken' => [ 'shape' => 'token', 'location' => 'querystring', 'locationName' => 'next-token', ], 'MaxResults' => [ 'shape' => 'maxSize100', 'location' => 'querystring', 'locationName' => 'max-results', ], ], ], 'ListEventStreamsResponse' => [ 'type' => 'structure', 'members' => [ 'Items' => [ 'shape' => 'EventStreamSummaryList', ], 'NextToken' => [ 'shape' => 'token', ], ], ], 'ListEventTriggersRequest' => [ 'type' => 'structure', 'required' => [ 'DomainName', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], 'NextToken' => [ 'shape' => 'token', 'location' => 'querystring', 'locationName' => 'next-token', ], 'MaxResults' => [ 'shape' => 'maxSize100', 'location' => 'querystring', 'locationName' => 'max-results', ], ], ], 'ListEventTriggersResponse' => [ 'type' => 'structure', 'members' => [ 'Items' => [ 'shape' => 'EventTriggerSummaryList', ], 'NextToken' => [ 'shape' => 'token', ], ], ], 'ListIdentityResolutionJobsRequest' => [ 'type' => 'structure', 'required' => [ 'DomainName', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], 'NextToken' => [ 'shape' => 'token', 'location' => 'querystring', 'locationName' => 'next-token', ], 'MaxResults' => [ 'shape' => 'maxSize100', 'location' => 'querystring', 'locationName' => 'max-results', ], ], ], 'ListIdentityResolutionJobsResponse' => [ 'type' => 'structure', 'members' => [ 'IdentityResolutionJobsList' => [ 'shape' => 'IdentityResolutionJobsList', ], 'NextToken' => [ 'shape' => 'token', ], ], ], 'ListIntegrationItem' => [ 'type' => 'structure', 'required' => [ 'DomainName', 'Uri', 'CreatedAt', 'LastUpdatedAt', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', ], 'Uri' => [ 'shape' => 'string1To255', ], 'ObjectTypeName' => [ 'shape' => 'typeName', ], 'CreatedAt' => [ 'shape' => 'timestamp', ], 'LastUpdatedAt' => [ 'shape' => 'timestamp', ], 'Tags' => [ 'shape' => 'TagMap', ], 'ObjectTypeNames' => [ 'shape' => 'ObjectTypeNames', ], 'WorkflowId' => [ 'shape' => 'string1To255', ], 'IsUnstructured' => [ 'shape' => 'optionalBoolean', ], 'RoleArn' => [ 'shape' => 'RoleArn', ], 'EventTriggerNames' => [ 'shape' => 'EventTriggerNames', ], ], ], 'ListIntegrationsRequest' => [ 'type' => 'structure', 'required' => [ 'DomainName', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], 'NextToken' => [ 'shape' => 'token', 'location' => 'querystring', 'locationName' => 'next-token', ], 'MaxResults' => [ 'shape' => 'maxSize100', 'location' => 'querystring', 'locationName' => 'max-results', ], 'IncludeHidden' => [ 'shape' => 'optionalBoolean', 'location' => 'querystring', 'locationName' => 'include-hidden', ], ], ], 'ListIntegrationsResponse' => [ 'type' => 'structure', 'members' => [ 'Items' => [ 'shape' => 'IntegrationList', ], 'NextToken' => [ 'shape' => 'token', ], ], ], 'ListObjectTypeAttributeItem' => [ 'type' => 'structure', 'required' => [ 'AttributeName', 'LastUpdatedAt', ], 'members' => [ 'AttributeName' => [ 'shape' => 'name', ], 'LastUpdatedAt' => [ 'shape' => 'timestamp', ], ], ], 'ListObjectTypeAttributesList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ListObjectTypeAttributeItem', ], ], 'ListObjectTypeAttributesRequest' => [ 'type' => 'structure', 'required' => [ 'DomainName', 'ObjectTypeName', ], 'members' => [ 'NextToken' => [ 'shape' => 'token', 'location' => 'querystring', 'locationName' => 'next-token', ], 'MaxResults' => [ 'shape' => 'maxSize100', 'location' => 'querystring', 'locationName' => 'max-results', ], 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], 'ObjectTypeName' => [ 'shape' => 'typeName', 'location' => 'uri', 'locationName' => 'ObjectTypeName', ], ], ], 'ListObjectTypeAttributesResponse' => [ 'type' => 'structure', 'members' => [ 'Items' => [ 'shape' => 'ListObjectTypeAttributesList', ], 'NextToken' => [ 'shape' => 'token', ], ], ], 'ListProfileHistoryRecordsRequest' => [ 'type' => 'structure', 'required' => [ 'DomainName', 'ProfileId', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], 'ProfileId' => [ 'shape' => 'uuid', ], 'ObjectTypeName' => [ 'shape' => 'typeName', ], 'NextToken' => [ 'shape' => 'token', 'location' => 'querystring', 'locationName' => 'next-token', ], 'MaxResults' => [ 'shape' => 'maxSize100', 'location' => 'querystring', 'locationName' => 'max-results', ], 'ActionType' => [ 'shape' => 'ActionType', ], 'PerformedBy' => [ 'shape' => 'string1To255', ], ], ], 'ListProfileHistoryRecordsResponse' => [ 'type' => 'structure', 'members' => [ 'ProfileHistoryRecords' => [ 'shape' => 'ProfileHistoryRecords', ], 'NextToken' => [ 'shape' => 'token', ], ], ], 'ListProfileObjectTypeItem' => [ 'type' => 'structure', 'required' => [ 'ObjectTypeName', 'Description', ], 'members' => [ 'ObjectTypeName' => [ 'shape' => 'typeName', ], 'Description' => [ 'shape' => 'text', ], 'CreatedAt' => [ 'shape' => 'timestamp', ], 'LastUpdatedAt' => [ 'shape' => 'timestamp', ], 'MaxProfileObjectCount' => [ 'shape' => 'minSize1', ], 'MaxAvailableProfileObjectCount' => [ 'shape' => 'minSize0', ], 'Tags' => [ 'shape' => 'TagMap', ], ], ], 'ListProfileObjectTypeTemplateItem' => [ 'type' => 'structure', 'members' => [ 'TemplateId' => [ 'shape' => 'name', ], 'SourceName' => [ 'shape' => 'name', ], 'SourceObject' => [ 'shape' => 'name', ], ], ], 'ListProfileObjectTypeTemplatesRequest' => [ 'type' => 'structure', 'members' => [ 'NextToken' => [ 'shape' => 'token', 'location' => 'querystring', 'locationName' => 'next-token', ], 'MaxResults' => [ 'shape' => 'maxSize100', 'location' => 'querystring', 'locationName' => 'max-results', ], ], ], 'ListProfileObjectTypeTemplatesResponse' => [ 'type' => 'structure', 'members' => [ 'Items' => [ 'shape' => 'ProfileObjectTypeTemplateList', ], 'NextToken' => [ 'shape' => 'token', ], ], ], 'ListProfileObjectTypesRequest' => [ 'type' => 'structure', 'required' => [ 'DomainName', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], 'NextToken' => [ 'shape' => 'token', 'location' => 'querystring', 'locationName' => 'next-token', ], 'MaxResults' => [ 'shape' => 'maxSize100', 'location' => 'querystring', 'locationName' => 'max-results', ], ], ], 'ListProfileObjectTypesResponse' => [ 'type' => 'structure', 'members' => [ 'Items' => [ 'shape' => 'ProfileObjectTypeList', ], 'NextToken' => [ 'shape' => 'token', ], ], ], 'ListProfileObjectsItem' => [ 'type' => 'structure', 'members' => [ 'ObjectTypeName' => [ 'shape' => 'typeName', ], 'ProfileObjectUniqueKey' => [ 'shape' => 'string1To255', ], 'Object' => [ 'shape' => 'stringifiedJson', ], ], ], 'ListProfileObjectsRequest' => [ 'type' => 'structure', 'required' => [ 'DomainName', 'ObjectTypeName', 'ProfileId', ], 'members' => [ 'NextToken' => [ 'shape' => 'token', 'location' => 'querystring', 'locationName' => 'next-token', ], 'MaxResults' => [ 'shape' => 'maxSize100', 'location' => 'querystring', 'locationName' => 'max-results', ], 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], 'ObjectTypeName' => [ 'shape' => 'typeName', ], 'ProfileId' => [ 'shape' => 'uuid', ], 'ObjectFilter' => [ 'shape' => 'ObjectFilter', ], ], ], 'ListProfileObjectsResponse' => [ 'type' => 'structure', 'members' => [ 'Items' => [ 'shape' => 'ProfileObjectList', ], 'NextToken' => [ 'shape' => 'token', ], ], ], 'ListRuleBasedMatchesRequest' => [ 'type' => 'structure', 'required' => [ 'DomainName', ], 'members' => [ 'NextToken' => [ 'shape' => 'token', 'location' => 'querystring', 'locationName' => 'next-token', ], 'MaxResults' => [ 'shape' => 'maxSize100', 'location' => 'querystring', 'locationName' => 'max-results', ], 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], ], ], 'ListRuleBasedMatchesResponse' => [ 'type' => 'structure', 'members' => [ 'MatchIds' => [ 'shape' => 'MatchIdList', ], 'NextToken' => [ 'shape' => 'token', ], ], ], 'ListSegmentDefinitionsRequest' => [ 'type' => 'structure', 'required' => [ 'DomainName', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], 'MaxResults' => [ 'shape' => 'MaxSize500', 'location' => 'querystring', 'locationName' => 'max-results', ], 'NextToken' => [ 'shape' => 'token', 'location' => 'querystring', 'locationName' => 'next-token', ], ], ], 'ListSegmentDefinitionsResponse' => [ 'type' => 'structure', 'members' => [ 'NextToken' => [ 'shape' => 'token', 'locationName' => 'NextToken', ], 'Items' => [ 'shape' => 'SegmentDefinitionsList', 'locationName' => 'Items', ], ], ], 'ListTagsForResourceRequest' => [ 'type' => 'structure', 'required' => [ 'resourceArn', ], 'members' => [ 'resourceArn' => [ 'shape' => 'TagArn', 'location' => 'uri', 'locationName' => 'resourceArn', ], ], ], 'ListTagsForResourceResponse' => [ 'type' => 'structure', 'members' => [ 'tags' => [ 'shape' => 'TagMap', ], ], ], 'ListUploadJobsRequest' => [ 'type' => 'structure', 'required' => [ 'DomainName', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], 'MaxResults' => [ 'shape' => 'MaxSize500', 'location' => 'querystring', 'locationName' => 'max-results', ], 'NextToken' => [ 'shape' => 'token', 'location' => 'querystring', 'locationName' => 'next-token', ], ], ], 'ListUploadJobsResponse' => [ 'type' => 'structure', 'members' => [ 'NextToken' => [ 'shape' => 'token', 'locationName' => 'NextToken', ], 'Items' => [ 'shape' => 'UploadJobsList', 'locationName' => 'Items', ], ], ], 'ListWorkflowsItem' => [ 'type' => 'structure', 'required' => [ 'WorkflowType', 'WorkflowId', 'Status', 'StatusDescription', 'CreatedAt', 'LastUpdatedAt', ], 'members' => [ 'WorkflowType' => [ 'shape' => 'WorkflowType', ], 'WorkflowId' => [ 'shape' => 'string1To255', ], 'Status' => [ 'shape' => 'Status', ], 'StatusDescription' => [ 'shape' => 'string1To255', ], 'CreatedAt' => [ 'shape' => 'timestamp', ], 'LastUpdatedAt' => [ 'shape' => 'timestamp', ], ], ], 'ListWorkflowsRequest' => [ 'type' => 'structure', 'required' => [ 'DomainName', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], 'WorkflowType' => [ 'shape' => 'WorkflowType', ], 'Status' => [ 'shape' => 'Status', ], 'QueryStartDate' => [ 'shape' => 'timestamp', ], 'QueryEndDate' => [ 'shape' => 'timestamp', ], 'NextToken' => [ 'shape' => 'token', 'location' => 'querystring', 'locationName' => 'next-token', ], 'MaxResults' => [ 'shape' => 'maxSize100', 'location' => 'querystring', 'locationName' => 'max-results', ], ], ], 'ListWorkflowsResponse' => [ 'type' => 'structure', 'members' => [ 'Items' => [ 'shape' => 'WorkflowList', ], 'NextToken' => [ 'shape' => 'token', ], ], ], 'MarketoConnectorOperator' => [ 'type' => 'string', 'enum' => [ 'PROJECTION', 'LESS_THAN', 'GREATER_THAN', 'BETWEEN', 'ADDITION', 'MULTIPLICATION', 'DIVISION', 'SUBTRACTION', 'MASK_ALL', 'MASK_FIRST_N', 'MASK_LAST_N', 'VALIDATE_NON_NULL', 'VALIDATE_NON_ZERO', 'VALIDATE_NON_NEGATIVE', 'VALIDATE_NUMERIC', 'NO_OP', ], ], 'MarketoSourceProperties' => [ 'type' => 'structure', 'required' => [ 'Object', ], 'members' => [ 'Object' => [ 'shape' => 'Object', ], ], ], 'MatchIdList' => [ 'type' => 'list', 'member' => [ 'shape' => 'string1To255', ], ], 'MatchItem' => [ 'type' => 'structure', 'members' => [ 'MatchId' => [ 'shape' => 'string1To255', ], 'ProfileIds' => [ 'shape' => 'ProfileIdList', ], 'ConfidenceScore' => [ 'shape' => 'Double', ], ], ], 'MatchType' => [ 'type' => 'string', 'enum' => [ 'RULE_BASED_MATCHING', 'ML_BASED_MATCHING', ], ], 'MatchesList' => [ 'type' => 'list', 'member' => [ 'shape' => 'MatchItem', ], ], 'MatchingAttributes' => [ 'type' => 'list', 'member' => [ 'shape' => 'string1To255', ], 'max' => 20, 'min' => 1, ], 'MatchingAttributesList' => [ 'type' => 'list', 'member' => [ 'shape' => 'MatchingAttributes', ], 'max' => 10, 'min' => 1, ], 'MatchingRequest' => [ 'type' => 'structure', 'required' => [ 'Enabled', ], 'members' => [ 'Enabled' => [ 'shape' => 'optionalBoolean', ], 'JobSchedule' => [ 'shape' => 'JobSchedule', ], 'AutoMerging' => [ 'shape' => 'AutoMerging', ], 'ExportingConfig' => [ 'shape' => 'ExportingConfig', ], ], ], 'MatchingResponse' => [ 'type' => 'structure', 'members' => [ 'Enabled' => [ 'shape' => 'optionalBoolean', ], 'JobSchedule' => [ 'shape' => 'JobSchedule', ], 'AutoMerging' => [ 'shape' => 'AutoMerging', ], 'ExportingConfig' => [ 'shape' => 'ExportingConfig', ], ], ], 'MatchingRule' => [ 'type' => 'structure', 'required' => [ 'Rule', ], 'members' => [ 'Rule' => [ 'shape' => 'MatchingRuleAttributeList', ], ], ], 'MatchingRuleAttributeList' => [ 'type' => 'list', 'member' => [ 'shape' => 'string1To255', ], 'max' => 15, 'min' => 1, ], 'MatchingRules' => [ 'type' => 'list', 'member' => [ 'shape' => 'MatchingRule', ], 'max' => 15, 'min' => 1, ], 'MaxAllowedRuleLevelForMatching' => [ 'type' => 'integer', 'max' => 15, 'min' => 1, ], 'MaxAllowedRuleLevelForMerging' => [ 'type' => 'integer', 'max' => 15, 'min' => 1, ], 'MaxSize500' => [ 'type' => 'integer', 'box' => true, 'max' => 500, 'min' => 1, ], 'MergeProfilesRequest' => [ 'type' => 'structure', 'required' => [ 'DomainName', 'MainProfileId', 'ProfileIdsToBeMerged', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], 'MainProfileId' => [ 'shape' => 'uuid', ], 'ProfileIdsToBeMerged' => [ 'shape' => 'ProfileIdToBeMergedList', ], 'FieldSourceProfileIds' => [ 'shape' => 'FieldSourceProfileIds', ], ], ], 'MergeProfilesResponse' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'message', ], ], ], 'Object' => [ 'type' => 'string', 'max' => 512, 'pattern' => '\\S+', ], 'ObjectAttribute' => [ 'type' => 'structure', 'required' => [ 'ComparisonOperator', 'Values', ], 'members' => [ 'Source' => [ 'shape' => 'text', ], 'FieldName' => [ 'shape' => 'fieldName', ], 'ComparisonOperator' => [ 'shape' => 'ComparisonOperator', ], 'Values' => [ 'shape' => 'EventTriggerValues', ], ], ], 'ObjectAttributes' => [ 'type' => 'list', 'member' => [ 'shape' => 'ObjectAttribute', ], 'max' => 10, 'min' => 1, ], 'ObjectCount' => [ 'type' => 'integer', 'min' => 1, ], 'ObjectFilter' => [ 'type' => 'structure', 'required' => [ 'KeyName', 'Values', ], 'members' => [ 'KeyName' => [ 'shape' => 'name', ], 'Values' => [ 'shape' => 'requestValueList', ], ], ], 'ObjectTypeField' => [ 'type' => 'structure', 'members' => [ 'Source' => [ 'shape' => 'text', ], 'Target' => [ 'shape' => 'text', ], 'ContentType' => [ 'shape' => 'FieldContentType', ], ], ], 'ObjectTypeKey' => [ 'type' => 'structure', 'members' => [ 'StandardIdentifiers' => [ 'shape' => 'StandardIdentifierList', ], 'FieldNames' => [ 'shape' => 'FieldNameList', ], ], ], 'ObjectTypeKeyList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ObjectTypeKey', ], ], 'ObjectTypeNames' => [ 'type' => 'map', 'key' => [ 'shape' => 'string1To255', ], 'value' => [ 'shape' => 'typeName', ], ], 'Objects' => [ 'type' => 'list', 'member' => [ 'shape' => 'stringifiedJson', ], 'max' => 5, 'min' => 1, 'sensitive' => true, ], 'Operator' => [ 'type' => 'string', 'enum' => [ 'EQUAL_TO', 'GREATER_THAN', 'LESS_THAN', 'NOT_EQUAL_TO', ], ], 'OperatorPropertiesKeys' => [ 'type' => 'string', 'enum' => [ 'VALUE', 'VALUES', 'DATA_TYPE', 'UPPER_BOUND', 'LOWER_BOUND', 'SOURCE_DATA_TYPE', 'DESTINATION_DATA_TYPE', 'VALIDATION_ACTION', 'MASK_VALUE', 'MASK_LENGTH', 'TRUNCATE_LENGTH', 'MATH_OPERATION_FIELDS_ORDER', 'CONCAT_FORMAT', 'SUBFIELD_CATEGORY_MAP', ], ], 'PartyType' => [ 'type' => 'string', 'deprecated' => true, 'enum' => [ 'INDIVIDUAL', 'BUSINESS', 'OTHER', ], 'sensitive' => true, ], 'Period' => [ 'type' => 'structure', 'required' => [ 'Unit', 'Value', ], 'members' => [ 'Unit' => [ 'shape' => 'PeriodUnit', ], 'Value' => [ 'shape' => 'maxSize24', ], 'MaxInvocationsPerProfile' => [ 'shape' => 'maxSize1000', ], 'Unlimited' => [ 'shape' => 'boolean', ], ], ], 'PeriodUnit' => [ 'type' => 'string', 'enum' => [ 'HOURS', 'DAYS', 'WEEKS', 'MONTHS', ], ], 'Periods' => [ 'type' => 'list', 'member' => [ 'shape' => 'Period', ], 'max' => 4, 'min' => 1, ], 'PhoneNumberList' => [ 'type' => 'list', 'member' => [ 'shape' => 'string1To255', ], 'max' => 4, 'min' => 1, ], 'PhonePreferenceList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ContactPreference', ], ], 'Profile' => [ 'type' => 'structure', 'members' => [ 'ProfileId' => [ 'shape' => 'uuid', ], 'AccountNumber' => [ 'shape' => 'sensitiveString1To255', ], 'AdditionalInformation' => [ 'shape' => 'sensitiveString1To1000', ], 'PartyType' => [ 'shape' => 'PartyType', ], 'BusinessName' => [ 'shape' => 'sensitiveString1To255', ], 'FirstName' => [ 'shape' => 'sensitiveString1To255', ], 'MiddleName' => [ 'shape' => 'sensitiveString1To255', ], 'LastName' => [ 'shape' => 'sensitiveString1To255', ], 'BirthDate' => [ 'shape' => 'sensitiveString1To255', ], 'Gender' => [ 'shape' => 'Gender', ], 'PhoneNumber' => [ 'shape' => 'sensitiveString1To255', ], 'MobilePhoneNumber' => [ 'shape' => 'sensitiveString1To255', ], 'HomePhoneNumber' => [ 'shape' => 'sensitiveString1To255', ], 'BusinessPhoneNumber' => [ 'shape' => 'sensitiveString1To255', ], 'EmailAddress' => [ 'shape' => 'sensitiveString1To255', ], 'PersonalEmailAddress' => [ 'shape' => 'sensitiveString1To255', ], 'BusinessEmailAddress' => [ 'shape' => 'sensitiveString1To255', ], 'Address' => [ 'shape' => 'Address', ], 'ShippingAddress' => [ 'shape' => 'Address', ], 'MailingAddress' => [ 'shape' => 'Address', ], 'BillingAddress' => [ 'shape' => 'Address', ], 'Attributes' => [ 'shape' => 'Attributes', ], 'FoundByItems' => [ 'shape' => 'foundByList', ], 'PartyTypeString' => [ 'shape' => 'sensitiveString1To255', ], 'GenderString' => [ 'shape' => 'sensitiveString1To255', ], 'ProfileType' => [ 'shape' => 'ProfileType', ], 'EngagementPreferences' => [ 'shape' => 'EngagementPreferences', ], ], ], 'ProfileAttributeValuesRequest' => [ 'type' => 'structure', 'required' => [ 'DomainName', 'AttributeName', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], 'AttributeName' => [ 'shape' => 'string1To255', 'location' => 'uri', 'locationName' => 'AttributeName', ], ], ], 'ProfileAttributeValuesResponse' => [ 'type' => 'structure', 'members' => [ 'DomainName' => [ 'shape' => 'name', ], 'AttributeName' => [ 'shape' => 'string1To255', ], 'Items' => [ 'shape' => 'AttributeValueItemList', ], 'StatusCode' => [ 'shape' => 'StatusCode', 'location' => 'statusCode', ], ], ], 'ProfileAttributes' => [ 'type' => 'structure', 'members' => [ 'AccountNumber' => [ 'shape' => 'ProfileDimension', 'locationName' => 'AccountNumber', ], 'AdditionalInformation' => [ 'shape' => 'ExtraLengthValueProfileDimension', 'locationName' => 'AdditionalInformation', ], 'FirstName' => [ 'shape' => 'ProfileDimension', 'locationName' => 'FirstName', ], 'LastName' => [ 'shape' => 'ProfileDimension', 'locationName' => 'LastName', ], 'MiddleName' => [ 'shape' => 'ProfileDimension', 'locationName' => 'MiddleName', ], 'GenderString' => [ 'shape' => 'ProfileDimension', 'locationName' => 'GenderString', ], 'PartyTypeString' => [ 'shape' => 'ProfileDimension', 'locationName' => 'PartyTypeString', ], 'BirthDate' => [ 'shape' => 'DateDimension', 'locationName' => 'BirthDate', ], 'PhoneNumber' => [ 'shape' => 'ProfileDimension', 'locationName' => 'PhoneNumber', ], 'BusinessName' => [ 'shape' => 'ProfileDimension', 'locationName' => 'BusinessName', ], 'BusinessPhoneNumber' => [ 'shape' => 'ProfileDimension', 'locationName' => 'BusinessPhoneNumber', ], 'HomePhoneNumber' => [ 'shape' => 'ProfileDimension', 'locationName' => 'HomePhoneNumber', ], 'MobilePhoneNumber' => [ 'shape' => 'ProfileDimension', 'locationName' => 'MobilePhoneNumber', ], 'EmailAddress' => [ 'shape' => 'ProfileDimension', 'locationName' => 'EmailAddress', ], 'PersonalEmailAddress' => [ 'shape' => 'ProfileDimension', 'locationName' => 'PersonalEmailAddress', ], 'BusinessEmailAddress' => [ 'shape' => 'ProfileDimension', 'locationName' => 'BusinessEmailAddress', ], 'Address' => [ 'shape' => 'AddressDimension', 'locationName' => 'Address', ], 'ShippingAddress' => [ 'shape' => 'AddressDimension', 'locationName' => 'ShippingAddress', ], 'MailingAddress' => [ 'shape' => 'AddressDimension', 'locationName' => 'MailingAddress', ], 'BillingAddress' => [ 'shape' => 'AddressDimension', 'locationName' => 'BillingAddress', ], 'Attributes' => [ 'shape' => 'CustomAttributes', 'locationName' => 'Attributes', ], 'ProfileType' => [ 'shape' => 'ProfileTypeDimension', 'locationName' => 'ProfileType', ], ], 'sensitive' => true, ], 'ProfileDimension' => [ 'type' => 'structure', 'required' => [ 'DimensionType', 'Values', ], 'members' => [ 'DimensionType' => [ 'shape' => 'StringDimensionType', 'locationName' => 'DimensionType', ], 'Values' => [ 'shape' => 'Values', 'locationName' => 'Values', ], ], ], 'ProfileHistoryRecord' => [ 'type' => 'structure', 'required' => [ 'Id', 'ObjectTypeName', 'CreatedAt', 'ActionType', ], 'members' => [ 'Id' => [ 'shape' => 'uuid', ], 'ObjectTypeName' => [ 'shape' => 'typeName', ], 'CreatedAt' => [ 'shape' => 'timestamp', ], 'LastUpdatedAt' => [ 'shape' => 'timestamp', ], 'ActionType' => [ 'shape' => 'ActionType', ], 'ProfileObjectUniqueKey' => [ 'shape' => 'string1To255', ], 'PerformedBy' => [ 'shape' => 'string1To255', ], ], ], 'ProfileHistoryRecords' => [ 'type' => 'list', 'member' => [ 'shape' => 'ProfileHistoryRecord', ], ], 'ProfileId' => [ 'type' => 'string', ], 'ProfileIdList' => [ 'type' => 'list', 'member' => [ 'shape' => 'uuid', ], ], 'ProfileIdToBeMergedList' => [ 'type' => 'list', 'member' => [ 'shape' => 'uuid', ], 'max' => 20, 'min' => 1, ], 'ProfileIds' => [ 'type' => 'list', 'member' => [ 'shape' => 'uuid', ], 'max' => 100, 'min' => 1, ], 'ProfileList' => [ 'type' => 'list', 'member' => [ 'shape' => 'Profile', ], ], 'ProfileObjectList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ListProfileObjectsItem', ], ], 'ProfileObjectTypeList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ListProfileObjectTypeItem', ], 'sensitive' => true, ], 'ProfileObjectTypeTemplateList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ListProfileObjectTypeTemplateItem', ], ], 'ProfileQueryFailures' => [ 'type' => 'structure', 'required' => [ 'ProfileId', 'Message', ], 'members' => [ 'ProfileId' => [ 'shape' => 'ProfileId', 'locationName' => 'ProfileId', ], 'Message' => [ 'shape' => 'GetSegmentMembershipMessage', 'locationName' => 'Message', ], 'Status' => [ 'shape' => 'GetSegmentMembershipStatus', 'locationName' => 'Status', ], ], ], 'ProfileQueryResult' => [ 'type' => 'structure', 'required' => [ 'ProfileId', 'QueryResult', ], 'members' => [ 'ProfileId' => [ 'shape' => 'ProfileId', 'locationName' => 'ProfileId', ], 'QueryResult' => [ 'shape' => 'QueryResult', 'locationName' => 'QueryResult', ], 'Profile' => [ 'shape' => 'Profile', 'locationName' => 'Profile', ], ], ], 'ProfileType' => [ 'type' => 'string', 'enum' => [ 'ACCOUNT_PROFILE', 'PROFILE', ], 'sensitive' => true, ], 'ProfileTypeDimension' => [ 'type' => 'structure', 'required' => [ 'DimensionType', 'Values', ], 'members' => [ 'DimensionType' => [ 'shape' => 'ProfileTypeDimensionType', 'locationName' => 'DimensionType', ], 'Values' => [ 'shape' => 'ProfileTypeValues', 'locationName' => 'Values', ], ], ], 'ProfileTypeDimensionType' => [ 'type' => 'string', 'enum' => [ 'INCLUSIVE', 'EXCLUSIVE', ], ], 'ProfileTypeValues' => [ 'type' => 'list', 'member' => [ 'shape' => 'ProfileType', ], 'max' => 1, 'min' => 1, ], 'Profiles' => [ 'type' => 'list', 'member' => [ 'shape' => 'ProfileQueryResult', ], ], 'Property' => [ 'type' => 'string', 'max' => 2048, 'pattern' => '.+', ], 'PutIntegrationRequest' => [ 'type' => 'structure', 'required' => [ 'DomainName', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], 'Uri' => [ 'shape' => 'string1To255', ], 'ObjectTypeName' => [ 'shape' => 'typeName', ], 'Tags' => [ 'shape' => 'TagMap', ], 'FlowDefinition' => [ 'shape' => 'FlowDefinition', ], 'ObjectTypeNames' => [ 'shape' => 'ObjectTypeNames', ], 'RoleArn' => [ 'shape' => 'RoleArn', ], 'EventTriggerNames' => [ 'shape' => 'EventTriggerNames', ], ], ], 'PutIntegrationResponse' => [ 'type' => 'structure', 'required' => [ 'DomainName', 'Uri', 'CreatedAt', 'LastUpdatedAt', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', ], 'Uri' => [ 'shape' => 'string1To255', ], 'ObjectTypeName' => [ 'shape' => 'typeName', ], 'CreatedAt' => [ 'shape' => 'timestamp', ], 'LastUpdatedAt' => [ 'shape' => 'timestamp', ], 'Tags' => [ 'shape' => 'TagMap', ], 'ObjectTypeNames' => [ 'shape' => 'ObjectTypeNames', ], 'WorkflowId' => [ 'shape' => 'string1To255', ], 'IsUnstructured' => [ 'shape' => 'optionalBoolean', ], 'RoleArn' => [ 'shape' => 'RoleArn', ], 'EventTriggerNames' => [ 'shape' => 'EventTriggerNames', ], ], ], 'PutProfileObjectRequest' => [ 'type' => 'structure', 'required' => [ 'ObjectTypeName', 'Object', 'DomainName', ], 'members' => [ 'ObjectTypeName' => [ 'shape' => 'typeName', ], 'Object' => [ 'shape' => 'stringifiedJson', ], 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], ], ], 'PutProfileObjectResponse' => [ 'type' => 'structure', 'members' => [ 'ProfileObjectUniqueKey' => [ 'shape' => 'string1To255', ], ], ], 'PutProfileObjectTypeRequest' => [ 'type' => 'structure', 'required' => [ 'DomainName', 'ObjectTypeName', 'Description', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], 'ObjectTypeName' => [ 'shape' => 'typeName', 'location' => 'uri', 'locationName' => 'ObjectTypeName', ], 'Description' => [ 'shape' => 'sensitiveText', ], 'TemplateId' => [ 'shape' => 'name', ], 'ExpirationDays' => [ 'shape' => 'expirationDaysInteger', ], 'EncryptionKey' => [ 'shape' => 'encryptionKey', ], 'AllowProfileCreation' => [ 'shape' => 'boolean', ], 'SourceLastUpdatedTimestampFormat' => [ 'shape' => 'string1To255', ], 'MaxProfileObjectCount' => [ 'shape' => 'minSize1', ], 'Fields' => [ 'shape' => 'FieldMap', ], 'Keys' => [ 'shape' => 'KeyMap', ], 'Tags' => [ 'shape' => 'TagMap', ], ], ], 'PutProfileObjectTypeResponse' => [ 'type' => 'structure', 'required' => [ 'ObjectTypeName', 'Description', ], 'members' => [ 'ObjectTypeName' => [ 'shape' => 'typeName', ], 'Description' => [ 'shape' => 'sensitiveText', ], 'TemplateId' => [ 'shape' => 'name', ], 'ExpirationDays' => [ 'shape' => 'expirationDaysInteger', ], 'EncryptionKey' => [ 'shape' => 'encryptionKey', ], 'AllowProfileCreation' => [ 'shape' => 'boolean', ], 'SourceLastUpdatedTimestampFormat' => [ 'shape' => 'string1To255', ], 'MaxProfileObjectCount' => [ 'shape' => 'minSize1', ], 'MaxAvailableProfileObjectCount' => [ 'shape' => 'minSize0', ], 'Fields' => [ 'shape' => 'FieldMap', ], 'Keys' => [ 'shape' => 'KeyMap', ], 'CreatedAt' => [ 'shape' => 'timestamp', ], 'LastUpdatedAt' => [ 'shape' => 'timestamp', ], 'Tags' => [ 'shape' => 'TagMap', ], ], ], 'QueryResult' => [ 'type' => 'string', 'enum' => [ 'PRESENT', 'ABSENT', ], ], 'Range' => [ 'type' => 'structure', 'members' => [ 'Value' => [ 'shape' => 'Value', ], 'Unit' => [ 'shape' => 'Unit', ], 'ValueRange' => [ 'shape' => 'ValueRange', ], 'TimestampSource' => [ 'shape' => 'string1To255', ], 'TimestampFormat' => [ 'shape' => 'string1To255', ], ], ], 'RangeOverride' => [ 'type' => 'structure', 'required' => [ 'Start', 'Unit', ], 'members' => [ 'Start' => [ 'shape' => 'Start', ], 'End' => [ 'shape' => 'End', ], 'Unit' => [ 'shape' => 'RangeUnit', ], ], ], 'RangeUnit' => [ 'type' => 'string', 'enum' => [ 'DAYS', ], ], 'Readiness' => [ 'type' => 'structure', 'members' => [ 'ProgressPercentage' => [ 'shape' => 'percentageInteger', ], 'Message' => [ 'shape' => 'text', ], ], ], 'ReadinessStatus' => [ 'type' => 'string', 'enum' => [ 'PREPARING', 'IN_PROGRESS', 'COMPLETED', 'FAILED', ], ], 'ResourceNotFoundException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'message', ], ], 'error' => [ 'httpStatusCode' => 404, ], 'exception' => true, ], 'ResultsSummary' => [ 'type' => 'structure', 'members' => [ 'UpdatedRecords' => [ 'shape' => 'optionalLong', 'locationName' => 'UpdatedRecords', ], 'CreatedRecords' => [ 'shape' => 'optionalLong', 'locationName' => 'CreatedRecords', ], 'FailedRecords' => [ 'shape' => 'optionalLong', 'locationName' => 'FailedRecords', ], ], ], 'RoleArn' => [ 'type' => 'string', 'max' => 512, 'pattern' => 'arn:aws:iam:.*:[0-9]+:.*', ], 'RuleBasedMatchingRequest' => [ 'type' => 'structure', 'required' => [ 'Enabled', ], 'members' => [ 'Enabled' => [ 'shape' => 'optionalBoolean', ], 'MatchingRules' => [ 'shape' => 'MatchingRules', ], 'MaxAllowedRuleLevelForMerging' => [ 'shape' => 'MaxAllowedRuleLevelForMerging', ], 'MaxAllowedRuleLevelForMatching' => [ 'shape' => 'MaxAllowedRuleLevelForMatching', ], 'AttributeTypesSelector' => [ 'shape' => 'AttributeTypesSelector', ], 'ConflictResolution' => [ 'shape' => 'ConflictResolution', ], 'ExportingConfig' => [ 'shape' => 'ExportingConfig', ], ], ], 'RuleBasedMatchingResponse' => [ 'type' => 'structure', 'members' => [ 'Enabled' => [ 'shape' => 'optionalBoolean', ], 'MatchingRules' => [ 'shape' => 'MatchingRules', ], 'Status' => [ 'shape' => 'RuleBasedMatchingStatus', ], 'MaxAllowedRuleLevelForMerging' => [ 'shape' => 'MaxAllowedRuleLevelForMerging', ], 'MaxAllowedRuleLevelForMatching' => [ 'shape' => 'MaxAllowedRuleLevelForMatching', ], 'AttributeTypesSelector' => [ 'shape' => 'AttributeTypesSelector', ], 'ConflictResolution' => [ 'shape' => 'ConflictResolution', ], 'ExportingConfig' => [ 'shape' => 'ExportingConfig', ], ], ], 'RuleBasedMatchingStatus' => [ 'type' => 'string', 'enum' => [ 'PENDING', 'IN_PROGRESS', 'ACTIVE', ], ], 'RuleLevel' => [ 'type' => 'integer', 'max' => 15, 'min' => 1, ], 'S3ConnectorOperator' => [ 'type' => 'string', 'enum' => [ 'PROJECTION', 'LESS_THAN', 'GREATER_THAN', 'BETWEEN', 'LESS_THAN_OR_EQUAL_TO', 'GREATER_THAN_OR_EQUAL_TO', 'EQUAL_TO', 'NOT_EQUAL_TO', 'ADDITION', 'MULTIPLICATION', 'DIVISION', 'SUBTRACTION', 'MASK_ALL', 'MASK_FIRST_N', 'MASK_LAST_N', 'VALIDATE_NON_NULL', 'VALIDATE_NON_ZERO', 'VALIDATE_NON_NEGATIVE', 'VALIDATE_NUMERIC', 'NO_OP', ], ], 'S3ExportingConfig' => [ 'type' => 'structure', 'required' => [ 'S3BucketName', ], 'members' => [ 'S3BucketName' => [ 'shape' => 's3BucketName', ], 'S3KeyName' => [ 'shape' => 's3KeyNameCustomerOutputConfig', ], ], ], 'S3ExportingLocation' => [ 'type' => 'structure', 'members' => [ 'S3BucketName' => [ 'shape' => 's3BucketName', ], 'S3KeyName' => [ 'shape' => 's3KeyName', ], ], ], 'S3SourceProperties' => [ 'type' => 'structure', 'required' => [ 'BucketName', ], 'members' => [ 'BucketName' => [ 'shape' => 'BucketName', ], 'BucketPrefix' => [ 'shape' => 'BucketPrefix', ], ], ], 'SalesforceConnectorOperator' => [ 'type' => 'string', 'enum' => [ 'PROJECTION', 'LESS_THAN', 'CONTAINS', 'GREATER_THAN', 'BETWEEN', 'LESS_THAN_OR_EQUAL_TO', 'GREATER_THAN_OR_EQUAL_TO', 'EQUAL_TO', 'NOT_EQUAL_TO', 'ADDITION', 'MULTIPLICATION', 'DIVISION', 'SUBTRACTION', 'MASK_ALL', 'MASK_FIRST_N', 'MASK_LAST_N', 'VALIDATE_NON_NULL', 'VALIDATE_NON_ZERO', 'VALIDATE_NON_NEGATIVE', 'VALIDATE_NUMERIC', 'NO_OP', ], ], 'SalesforceSourceProperties' => [ 'type' => 'structure', 'required' => [ 'Object', ], 'members' => [ 'Object' => [ 'shape' => 'Object', ], 'EnableDynamicFieldUpdate' => [ 'shape' => 'boolean', ], 'IncludeDeletedRecords' => [ 'shape' => 'boolean', ], ], ], 'ScheduleExpression' => [ 'type' => 'string', 'max' => 256, 'pattern' => '.*', ], 'ScheduleOffset' => [ 'type' => 'long', 'max' => 36000, 'min' => 0, ], 'ScheduledTriggerProperties' => [ 'type' => 'structure', 'required' => [ 'ScheduleExpression', ], 'members' => [ 'ScheduleExpression' => [ 'shape' => 'ScheduleExpression', ], 'DataPullMode' => [ 'shape' => 'DataPullMode', ], 'ScheduleStartTime' => [ 'shape' => 'Date', ], 'ScheduleEndTime' => [ 'shape' => 'Date', ], 'Timezone' => [ 'shape' => 'Timezone', ], 'ScheduleOffset' => [ 'shape' => 'ScheduleOffset', 'box' => true, ], 'FirstExecutionFrom' => [ 'shape' => 'Date', ], ], ], 'SearchProfilesRequest' => [ 'type' => 'structure', 'required' => [ 'DomainName', 'KeyName', 'Values', ], 'members' => [ 'NextToken' => [ 'shape' => 'token', 'location' => 'querystring', 'locationName' => 'next-token', ], 'MaxResults' => [ 'shape' => 'maxSize100', 'location' => 'querystring', 'locationName' => 'max-results', ], 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], 'KeyName' => [ 'shape' => 'name', ], 'Values' => [ 'shape' => 'requestValueList', ], 'AdditionalSearchKeys' => [ 'shape' => 'additionalSearchKeysList', ], 'LogicalOperator' => [ 'shape' => 'logicalOperator', ], ], ], 'SearchProfilesResponse' => [ 'type' => 'structure', 'members' => [ 'Items' => [ 'shape' => 'ProfileList', ], 'NextToken' => [ 'shape' => 'token', ], ], ], 'SegmentDefinitionArn' => [ 'type' => 'string', 'max' => 255, 'min' => 1, ], 'SegmentDefinitionItem' => [ 'type' => 'structure', 'members' => [ 'SegmentDefinitionName' => [ 'shape' => 'name', 'locationName' => 'SegmentDefinitionName', ], 'DisplayName' => [ 'shape' => 'string1To255', 'locationName' => 'DisplayName', ], 'Description' => [ 'shape' => 'sensitiveText', 'locationName' => 'Description', ], 'SegmentDefinitionArn' => [ 'shape' => 'SegmentDefinitionArn', 'locationName' => 'SegmentDefinitionArn', ], 'CreatedAt' => [ 'shape' => 'timestamp', 'locationName' => 'CreatedAt', ], 'Tags' => [ 'shape' => 'TagMap', 'locationName' => 'Tags', ], ], ], 'SegmentDefinitionsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'SegmentDefinitionItem', ], ], 'SegmentGroup' => [ 'type' => 'structure', 'members' => [ 'Groups' => [ 'shape' => 'SegmentGroupList', 'locationName' => 'Groups', ], 'Include' => [ 'shape' => 'IncludeOptions', 'locationName' => 'Include', ], ], 'sensitive' => true, ], 'SegmentGroupList' => [ 'type' => 'list', 'member' => [ 'shape' => 'Group', ], ], 'SegmentGroupStructure' => [ 'type' => 'structure', 'members' => [ 'Groups' => [ 'shape' => 'SegmentGroupList', ], 'Include' => [ 'shape' => 'IncludeOptions', ], ], ], 'SegmentSnapshotStatus' => [ 'type' => 'string', 'enum' => [ 'COMPLETED', 'IN_PROGRESS', 'FAILED', ], ], 'ServiceNowConnectorOperator' => [ 'type' => 'string', 'enum' => [ 'PROJECTION', 'CONTAINS', 'LESS_THAN', 'GREATER_THAN', 'BETWEEN', 'LESS_THAN_OR_EQUAL_TO', 'GREATER_THAN_OR_EQUAL_TO', 'EQUAL_TO', 'NOT_EQUAL_TO', 'ADDITION', 'MULTIPLICATION', 'DIVISION', 'SUBTRACTION', 'MASK_ALL', 'MASK_FIRST_N', 'MASK_LAST_N', 'VALIDATE_NON_NULL', 'VALIDATE_NON_ZERO', 'VALIDATE_NON_NEGATIVE', 'VALIDATE_NUMERIC', 'NO_OP', ], ], 'ServiceNowSourceProperties' => [ 'type' => 'structure', 'required' => [ 'Object', ], 'members' => [ 'Object' => [ 'shape' => 'Object', ], ], ], 'SourceConnectorProperties' => [ 'type' => 'structure', 'members' => [ 'Marketo' => [ 'shape' => 'MarketoSourceProperties', ], 'S3' => [ 'shape' => 'S3SourceProperties', ], 'Salesforce' => [ 'shape' => 'SalesforceSourceProperties', ], 'ServiceNow' => [ 'shape' => 'ServiceNowSourceProperties', ], 'Zendesk' => [ 'shape' => 'ZendeskSourceProperties', ], ], ], 'SourceConnectorType' => [ 'type' => 'string', 'enum' => [ 'Salesforce', 'Marketo', 'Zendesk', 'Servicenow', 'S3', ], ], 'SourceFields' => [ 'type' => 'list', 'member' => [ 'shape' => 'stringTo2048', ], ], 'SourceFlowConfig' => [ 'type' => 'structure', 'required' => [ 'ConnectorType', 'SourceConnectorProperties', ], 'members' => [ 'ConnectorProfileName' => [ 'shape' => 'ConnectorProfileName', ], 'ConnectorType' => [ 'shape' => 'SourceConnectorType', ], 'IncrementalPullConfig' => [ 'shape' => 'IncrementalPullConfig', ], 'SourceConnectorProperties' => [ 'shape' => 'SourceConnectorProperties', ], ], ], 'SourceSegment' => [ 'type' => 'structure', 'members' => [ 'SegmentDefinitionName' => [ 'shape' => 'name', 'locationName' => 'SegmentDefinitionName', ], ], ], 'SourceSegmentList' => [ 'type' => 'list', 'member' => [ 'shape' => 'SourceSegment', ], ], 'StandardIdentifier' => [ 'type' => 'string', 'enum' => [ 'PROFILE', 'ASSET', 'CASE', 'ORDER', 'COMMUNICATION_RECORD', 'AIR_PREFERENCE', 'HOTEL_PREFERENCE', 'AIR_BOOKING', 'AIR_SEGMENT', 'HOTEL_RESERVATION', 'HOTEL_STAY_REVENUE', 'LOYALTY', 'LOYALTY_TRANSACTION', 'LOYALTY_PROMOTION', 'UNIQUE', 'SECONDARY', 'LOOKUP_ONLY', 'NEW_ONLY', ], ], 'StandardIdentifierList' => [ 'type' => 'list', 'member' => [ 'shape' => 'StandardIdentifier', ], ], 'Start' => [ 'type' => 'integer', ], 'StartUploadJobRequest' => [ 'type' => 'structure', 'required' => [ 'DomainName', 'JobId', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], 'JobId' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'JobId', ], ], ], 'StartUploadJobResponse' => [ 'type' => 'structure', 'members' => [], ], 'Statistic' => [ 'type' => 'string', 'enum' => [ 'FIRST_OCCURRENCE', 'LAST_OCCURRENCE', 'COUNT', 'SUM', 'MINIMUM', 'MAXIMUM', 'AVERAGE', 'MAX_OCCURRENCE', ], 'sensitive' => true, ], 'Status' => [ 'type' => 'string', 'enum' => [ 'NOT_STARTED', 'IN_PROGRESS', 'COMPLETE', 'FAILED', 'SPLIT', 'RETRY', 'CANCELLED', ], ], 'StatusCode' => [ 'type' => 'integer', ], 'StatusReason' => [ 'type' => 'string', 'enum' => [ 'VALIDATION_FAILURE', 'INTERNAL_FAILURE', ], ], 'StopUploadJobRequest' => [ 'type' => 'structure', 'required' => [ 'DomainName', 'JobId', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], 'JobId' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'JobId', ], ], ], 'StopUploadJobResponse' => [ 'type' => 'structure', 'members' => [], ], 'String' => [ 'type' => 'string', ], 'StringDimensionType' => [ 'type' => 'string', 'enum' => [ 'INCLUSIVE', 'EXCLUSIVE', 'CONTAINS', 'BEGINS_WITH', 'ENDS_WITH', ], ], 'TagArn' => [ 'type' => 'string', 'max' => 256, 'pattern' => '^arn:[a-z0-9]{1,10}:profile', ], 'TagKey' => [ 'type' => 'string', 'max' => 128, 'min' => 1, 'pattern' => '^(?!aws:)[a-zA-Z+-=._:/]+$', ], 'TagKeyList' => [ 'type' => 'list', 'member' => [ 'shape' => 'TagKey', ], 'max' => 50, 'min' => 1, ], 'TagMap' => [ 'type' => 'map', 'key' => [ 'shape' => 'TagKey', ], 'value' => [ 'shape' => 'TagValue', ], 'max' => 50, 'min' => 1, ], 'TagResourceRequest' => [ 'type' => 'structure', 'required' => [ 'resourceArn', 'tags', ], 'members' => [ 'resourceArn' => [ 'shape' => 'TagArn', 'location' => 'uri', 'locationName' => 'resourceArn', ], 'tags' => [ 'shape' => 'TagMap', ], ], ], 'TagResourceResponse' => [ 'type' => 'structure', 'members' => [], ], 'TagValue' => [ 'type' => 'string', 'max' => 256, ], 'Task' => [ 'type' => 'structure', 'required' => [ 'SourceFields', 'TaskType', ], 'members' => [ 'ConnectorOperator' => [ 'shape' => 'ConnectorOperator', ], 'DestinationField' => [ 'shape' => 'DestinationField', ], 'SourceFields' => [ 'shape' => 'SourceFields', ], 'TaskProperties' => [ 'shape' => 'TaskPropertiesMap', ], 'TaskType' => [ 'shape' => 'TaskType', ], ], ], 'TaskPropertiesMap' => [ 'type' => 'map', 'key' => [ 'shape' => 'OperatorPropertiesKeys', ], 'value' => [ 'shape' => 'Property', ], ], 'TaskType' => [ 'type' => 'string', 'enum' => [ 'Arithmetic', 'Filter', 'Map', 'Mask', 'Merge', 'Truncate', 'Validate', ], ], 'Tasks' => [ 'type' => 'list', 'member' => [ 'shape' => 'Task', ], ], 'Threshold' => [ 'type' => 'structure', 'required' => [ 'Value', 'Operator', ], 'members' => [ 'Value' => [ 'shape' => 'string1To255', ], 'Operator' => [ 'shape' => 'Operator', ], ], ], 'ThrottlingException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'message', ], ], 'error' => [ 'httpStatusCode' => 429, ], 'exception' => true, ], 'Timezone' => [ 'type' => 'string', 'max' => 256, 'pattern' => '.*', ], 'TriggerConfig' => [ 'type' => 'structure', 'required' => [ 'TriggerType', ], 'members' => [ 'TriggerType' => [ 'shape' => 'TriggerType', ], 'TriggerProperties' => [ 'shape' => 'TriggerProperties', ], ], ], 'TriggerProperties' => [ 'type' => 'structure', 'members' => [ 'Scheduled' => [ 'shape' => 'ScheduledTriggerProperties', ], ], ], 'TriggerType' => [ 'type' => 'string', 'enum' => [ 'Scheduled', 'Event', 'OnDemand', ], ], 'Type' => [ 'type' => 'string', 'enum' => [ 'ALL', 'ANY', 'NONE', ], ], 'Unit' => [ 'type' => 'string', 'enum' => [ 'DAYS', ], ], 'UntagResourceRequest' => [ 'type' => 'structure', 'required' => [ 'resourceArn', 'tagKeys', ], 'members' => [ 'resourceArn' => [ 'shape' => 'TagArn', 'location' => 'uri', 'locationName' => 'resourceArn', ], 'tagKeys' => [ 'shape' => 'TagKeyList', 'location' => 'querystring', 'locationName' => 'tagKeys', ], ], ], 'UntagResourceResponse' => [ 'type' => 'structure', 'members' => [], ], 'UpdateAddress' => [ 'type' => 'structure', 'members' => [ 'Address1' => [ 'shape' => 'string0To255', ], 'Address2' => [ 'shape' => 'string0To255', ], 'Address3' => [ 'shape' => 'string0To255', ], 'Address4' => [ 'shape' => 'string0To255', ], 'City' => [ 'shape' => 'string0To255', ], 'County' => [ 'shape' => 'string0To255', ], 'State' => [ 'shape' => 'string0To255', ], 'Province' => [ 'shape' => 'string0To255', ], 'Country' => [ 'shape' => 'string0To255', ], 'PostalCode' => [ 'shape' => 'string0To255', ], ], 'sensitive' => true, ], 'UpdateAttributes' => [ 'type' => 'map', 'key' => [ 'shape' => 'string1To255', ], 'value' => [ 'shape' => 'string0To255', ], 'sensitive' => true, ], 'UpdateCalculatedAttributeDefinitionRequest' => [ 'type' => 'structure', 'required' => [ 'DomainName', 'CalculatedAttributeName', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], 'CalculatedAttributeName' => [ 'shape' => 'typeName', 'location' => 'uri', 'locationName' => 'CalculatedAttributeName', ], 'DisplayName' => [ 'shape' => 'displayName', ], 'Description' => [ 'shape' => 'sensitiveText', ], 'Conditions' => [ 'shape' => 'Conditions', ], ], ], 'UpdateCalculatedAttributeDefinitionResponse' => [ 'type' => 'structure', 'members' => [ 'CalculatedAttributeName' => [ 'shape' => 'typeName', ], 'DisplayName' => [ 'shape' => 'displayName', ], 'Description' => [ 'shape' => 'sensitiveText', ], 'CreatedAt' => [ 'shape' => 'timestamp', ], 'LastUpdatedAt' => [ 'shape' => 'timestamp', ], 'Statistic' => [ 'shape' => 'Statistic', ], 'Conditions' => [ 'shape' => 'Conditions', ], 'AttributeDetails' => [ 'shape' => 'AttributeDetails', ], 'UseHistoricalData' => [ 'shape' => 'optionalBoolean', ], 'Status' => [ 'shape' => 'ReadinessStatus', ], 'Readiness' => [ 'shape' => 'Readiness', ], 'Tags' => [ 'shape' => 'TagMap', ], ], ], 'UpdateDomainLayoutRequest' => [ 'type' => 'structure', 'required' => [ 'DomainName', 'LayoutDefinitionName', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], 'LayoutDefinitionName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'LayoutDefinitionName', ], 'Description' => [ 'shape' => 'sensitiveText', ], 'DisplayName' => [ 'shape' => 'displayName', ], 'IsDefault' => [ 'shape' => 'boolean', ], 'LayoutType' => [ 'shape' => 'LayoutType', ], 'Layout' => [ 'shape' => 'sensitiveString1To2000000', ], ], ], 'UpdateDomainLayoutResponse' => [ 'type' => 'structure', 'members' => [ 'LayoutDefinitionName' => [ 'shape' => 'name', ], 'Description' => [ 'shape' => 'sensitiveText', ], 'DisplayName' => [ 'shape' => 'displayName', ], 'IsDefault' => [ 'shape' => 'boolean', ], 'LayoutType' => [ 'shape' => 'LayoutType', ], 'Layout' => [ 'shape' => 'sensitiveString1To2000000', ], 'Version' => [ 'shape' => 'string1To255', ], 'CreatedAt' => [ 'shape' => 'timestamp', ], 'LastUpdatedAt' => [ 'shape' => 'timestamp', ], 'Tags' => [ 'shape' => 'TagMap', ], ], ], 'UpdateDomainRequest' => [ 'type' => 'structure', 'required' => [ 'DomainName', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], 'DefaultExpirationDays' => [ 'shape' => 'expirationDaysInteger', ], 'DefaultEncryptionKey' => [ 'shape' => 'encryptionKey', ], 'DeadLetterQueueUrl' => [ 'shape' => 'sqsQueueUrl', ], 'Matching' => [ 'shape' => 'MatchingRequest', ], 'RuleBasedMatching' => [ 'shape' => 'RuleBasedMatchingRequest', ], 'Tags' => [ 'shape' => 'TagMap', ], ], ], 'UpdateDomainResponse' => [ 'type' => 'structure', 'required' => [ 'DomainName', 'CreatedAt', 'LastUpdatedAt', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', ], 'DefaultExpirationDays' => [ 'shape' => 'expirationDaysInteger', ], 'DefaultEncryptionKey' => [ 'shape' => 'encryptionKey', ], 'DeadLetterQueueUrl' => [ 'shape' => 'sqsQueueUrl', ], 'Matching' => [ 'shape' => 'MatchingResponse', ], 'RuleBasedMatching' => [ 'shape' => 'RuleBasedMatchingResponse', ], 'CreatedAt' => [ 'shape' => 'timestamp', ], 'LastUpdatedAt' => [ 'shape' => 'timestamp', ], 'Tags' => [ 'shape' => 'TagMap', ], ], ], 'UpdateEventTriggerRequest' => [ 'type' => 'structure', 'required' => [ 'DomainName', 'EventTriggerName', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], 'EventTriggerName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'EventTriggerName', ], 'ObjectTypeName' => [ 'shape' => 'typeName', ], 'Description' => [ 'shape' => 'sensitiveText', ], 'EventTriggerConditions' => [ 'shape' => 'EventTriggerConditions', ], 'SegmentFilter' => [ 'shape' => 'name', ], 'EventTriggerLimits' => [ 'shape' => 'EventTriggerLimits', ], ], ], 'UpdateEventTriggerResponse' => [ 'type' => 'structure', 'members' => [ 'EventTriggerName' => [ 'shape' => 'name', ], 'ObjectTypeName' => [ 'shape' => 'typeName', ], 'Description' => [ 'shape' => 'sensitiveText', ], 'EventTriggerConditions' => [ 'shape' => 'EventTriggerConditions', ], 'SegmentFilter' => [ 'shape' => 'name', ], 'EventTriggerLimits' => [ 'shape' => 'EventTriggerLimits', ], 'CreatedAt' => [ 'shape' => 'timestamp', ], 'LastUpdatedAt' => [ 'shape' => 'timestamp', ], 'Tags' => [ 'shape' => 'TagMap', ], ], ], 'UpdateProfileRequest' => [ 'type' => 'structure', 'required' => [ 'DomainName', 'ProfileId', ], 'members' => [ 'DomainName' => [ 'shape' => 'name', 'location' => 'uri', 'locationName' => 'DomainName', ], 'ProfileId' => [ 'shape' => 'uuid', ], 'AdditionalInformation' => [ 'shape' => 'sensitiveString0To1000', ], 'AccountNumber' => [ 'shape' => 'sensitiveString0To255', ], 'PartyType' => [ 'shape' => 'PartyType', ], 'BusinessName' => [ 'shape' => 'sensitiveString0To255', ], 'FirstName' => [ 'shape' => 'sensitiveString0To255', ], 'MiddleName' => [ 'shape' => 'sensitiveString0To255', ], 'LastName' => [ 'shape' => 'sensitiveString0To255', ], 'BirthDate' => [ 'shape' => 'sensitiveString0To255', ], 'Gender' => [ 'shape' => 'Gender', ], 'PhoneNumber' => [ 'shape' => 'sensitiveString0To255', ], 'MobilePhoneNumber' => [ 'shape' => 'sensitiveString0To255', ], 'HomePhoneNumber' => [ 'shape' => 'sensitiveString0To255', ], 'BusinessPhoneNumber' => [ 'shape' => 'sensitiveString0To255', ], 'EmailAddress' => [ 'shape' => 'sensitiveString0To255', ], 'PersonalEmailAddress' => [ 'shape' => 'sensitiveString0To255', ], 'BusinessEmailAddress' => [ 'shape' => 'sensitiveString0To255', ], 'Address' => [ 'shape' => 'UpdateAddress', ], 'ShippingAddress' => [ 'shape' => 'UpdateAddress', ], 'MailingAddress' => [ 'shape' => 'UpdateAddress', ], 'BillingAddress' => [ 'shape' => 'UpdateAddress', ], 'Attributes' => [ 'shape' => 'UpdateAttributes', ], 'PartyTypeString' => [ 'shape' => 'sensitiveString0To255', ], 'GenderString' => [ 'shape' => 'sensitiveString0To255', ], 'ProfileType' => [ 'shape' => 'ProfileType', ], 'EngagementPreferences' => [ 'shape' => 'EngagementPreferences', ], ], ], 'UpdateProfileResponse' => [ 'type' => 'structure', 'required' => [ 'ProfileId', ], 'members' => [ 'ProfileId' => [ 'shape' => 'uuid', ], ], ], 'UploadJobItem' => [ 'type' => 'structure', 'members' => [ 'JobId' => [ 'shape' => 'uuid', 'locationName' => 'JobId', ], 'DisplayName' => [ 'shape' => 'string1To255', 'locationName' => 'DisplayName', ], 'Status' => [ 'shape' => 'UploadJobStatus', 'locationName' => 'Status', ], 'StatusReason' => [ 'shape' => 'StatusReason', 'locationName' => 'StatusReason', ], 'CreatedAt' => [ 'shape' => 'timestamp', 'locationName' => 'CreatedAt', ], 'CompletedAt' => [ 'shape' => 'timestamp', 'locationName' => 'CompletedAt', ], 'DataExpiry' => [ 'shape' => 'expirationDaysInteger', 'locationName' => 'DataExpiry', ], ], ], 'UploadJobStatus' => [ 'type' => 'string', 'enum' => [ 'CREATED', 'IN_PROGRESS', 'PARTIALLY_SUCCEEDED', 'SUCCEEDED', 'FAILED', 'STOPPED', ], ], 'UploadJobsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'UploadJobItem', ], ], 'Value' => [ 'type' => 'integer', 'max' => 2147483647, 'min' => 0, ], 'ValueList' => [ 'type' => 'list', 'member' => [ 'shape' => 'string1To255', ], 'max' => 10, 'min' => 1, ], 'ValueRange' => [ 'type' => 'structure', 'required' => [ 'Start', 'End', ], 'members' => [ 'Start' => [ 'shape' => 'ValueRangeStart', ], 'End' => [ 'shape' => 'ValueRangeEnd', ], ], ], 'ValueRangeEnd' => [ 'type' => 'integer', ], 'ValueRangeStart' => [ 'type' => 'integer', ], 'Values' => [ 'type' => 'list', 'member' => [ 'shape' => 'string1To255', ], 'max' => 50, 'min' => 1, ], 'WorkflowAttributes' => [ 'type' => 'structure', 'members' => [ 'AppflowIntegration' => [ 'shape' => 'AppflowIntegrationWorkflowAttributes', ], ], ], 'WorkflowList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ListWorkflowsItem', ], ], 'WorkflowMetrics' => [ 'type' => 'structure', 'members' => [ 'AppflowIntegration' => [ 'shape' => 'AppflowIntegrationWorkflowMetrics', ], ], ], 'WorkflowStepItem' => [ 'type' => 'structure', 'members' => [ 'AppflowIntegration' => [ 'shape' => 'AppflowIntegrationWorkflowStep', ], ], ], 'WorkflowStepsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'WorkflowStepItem', ], ], 'WorkflowType' => [ 'type' => 'string', 'enum' => [ 'APPFLOW_INTEGRATION', ], ], 'ZendeskConnectorOperator' => [ 'type' => 'string', 'enum' => [ 'PROJECTION', 'GREATER_THAN', 'ADDITION', 'MULTIPLICATION', 'DIVISION', 'SUBTRACTION', 'MASK_ALL', 'MASK_FIRST_N', 'MASK_LAST_N', 'VALIDATE_NON_NULL', 'VALIDATE_NON_ZERO', 'VALIDATE_NON_NEGATIVE', 'VALIDATE_NUMERIC', 'NO_OP', ], ], 'ZendeskSourceProperties' => [ 'type' => 'structure', 'required' => [ 'Object', ], 'members' => [ 'Object' => [ 'shape' => 'Object', ], ], ], 'additionalSearchKeysList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AdditionalSearchKey', ], 'max' => 4, 'min' => 1, ], 'attributeName' => [ 'type' => 'string', 'max' => 64, 'min' => 1, 'pattern' => '^[a-zA-Z0-9_.-]+$', ], 'boolean' => [ 'type' => 'boolean', ], 'displayName' => [ 'type' => 'string', 'max' => 255, 'min' => 1, 'pattern' => '^[a-zA-Z_][a-zA-Z_0-9-\\s]*$', ], 'encryptionKey' => [ 'type' => 'string', 'max' => 255, 'min' => 0, ], 'expirationDaysInteger' => [ 'type' => 'integer', 'max' => 1098, 'min' => 1, ], 'fieldName' => [ 'type' => 'string', 'max' => 64, 'min' => 1, 'pattern' => '^[a-zA-Z0-9_.-]+$', ], 'foundByList' => [ 'type' => 'list', 'member' => [ 'shape' => 'FoundByKeyValue', ], 'max' => 5, 'min' => 1, ], 'logicalOperator' => [ 'type' => 'string', 'enum' => [ 'AND', 'OR', ], ], 'long' => [ 'type' => 'long', ], 'matchesNumber' => [ 'type' => 'integer', 'min' => 0, ], 'maxSize100' => [ 'type' => 'integer', 'max' => 100, 'min' => 1, ], 'maxSize1000' => [ 'type' => 'integer', 'max' => 1000, 'min' => 1, ], 'maxSize24' => [ 'type' => 'integer', 'max' => 24, 'min' => 1, ], 'message' => [ 'type' => 'string', ], 'minSize0' => [ 'type' => 'integer', 'min' => 0, ], 'minSize1' => [ 'type' => 'integer', 'min' => 1, ], 'optionalBoolean' => [ 'type' => 'boolean', ], 'optionalLong' => [ 'type' => 'long', ], 'percentageInteger' => [ 'type' => 'integer', 'max' => 100, 'min' => 0, ], 'requestValueList' => [ 'type' => 'list', 'member' => [ 'shape' => 'string1To255', ], ], 's3BucketName' => [ 'type' => 'string', 'max' => 63, 'min' => 3, 'pattern' => '^[a-z0-9.-]+$', ], 's3KeyName' => [ 'type' => 'string', 'max' => 1024, 'min' => 1, 'pattern' => '.*', ], 's3KeyNameCustomerOutputConfig' => [ 'type' => 'string', 'max' => 800, 'min' => 1, 'pattern' => '.*', ], 'sensitiveString0To1000' => [ 'type' => 'string', 'max' => 1000, 'min' => 0, 'sensitive' => true, ], 'sensitiveString0To255' => [ 'type' => 'string', 'max' => 255, 'min' => 0, 'sensitive' => true, ], 'sensitiveString1To1000' => [ 'type' => 'string', 'max' => 1000, 'min' => 1, 'sensitive' => true, ], 'sensitiveString1To2000000' => [ 'type' => 'string', 'max' => 2000000, 'min' => 1, 'sensitive' => true, ], 'sensitiveString1To255' => [ 'type' => 'string', 'max' => 255, 'min' => 1, 'sensitive' => true, ], 'sensitiveText' => [ 'type' => 'string', 'max' => 1000, 'min' => 1, 'sensitive' => true, ], 'sqsQueueUrl' => [ 'type' => 'string', 'max' => 255, 'min' => 0, ], 'string0To255' => [ 'type' => 'string', 'max' => 255, 'min' => 0, ], 'string1To1000' => [ 'type' => 'string', 'max' => 1000, 'min' => 1, ], 'string1To255' => [ 'type' => 'string', 'max' => 255, 'min' => 1, ], 'stringTo2048' => [ 'type' => 'string', 'max' => 2048, 'pattern' => '.*', ], 'stringifiedJson' => [ 'type' => 'string', 'max' => 256000, 'min' => 1, 'sensitive' => true, ], 'text' => [ 'type' => 'string', 'max' => 1000, 'min' => 1, ], 'timestamp' => [ 'type' => 'timestamp', ], 'token' => [ 'type' => 'string', 'max' => 1024, 'min' => 1, ], 'typeName' => [ 'type' => 'string', 'max' => 255, 'min' => 1, 'pattern' => '^[a-zA-Z_][a-zA-Z_0-9-]*$', ], 'uuid' => [ 'type' => 'string', 'pattern' => '[a-f0-9]{32}', ], ],];
